/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import java.awt.Component;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

public class MleHeadRenderer
extends JList
implements TableCellRenderer {
    private transient Vector<String> _lines = new Vector();
    boolean _allowDefaultFont = false;
    private String _token = "\n";

    public MleHeadRenderer() {
        this.setOpaque(true);
        this.setForeground(UIManager.getColor("TableHeader.foreground"));
        this.setBackground(UIManager.getColor("TableHeader.background"));
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        this.setFont(UIManager.getFont("TableHeader.font"));
        ListCellRenderer renderer = this.getCellRenderer();
        ((JLabel)((Object)renderer)).setHorizontalAlignment(0);
        this.setCellRenderer(renderer);
    }

    public void setAllowDefaultFont(boolean state) {
        this._allowDefaultFont = state;
    }

    public boolean getAllowDefaultFont() {
        return this._allowDefaultFont;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String str = value == null ? "" : value.toString();
        this._lines.clear();
        if (table != null && table.isFontSet() && (!this._allowDefaultFont || this.getFont() == null)) {
            this.setFont(table.getFont());
        }
        if (str.length() == 0) {
            this._lines.add("");
        } else {
            StringTokenizer tokenizer = new StringTokenizer(str, this._token);
            while (tokenizer.hasMoreTokens()) {
                this._lines.add(tokenizer.nextToken());
            }
        }
        this.setListData(this._lines);
        return this;
    }

    public void setSeparatorToken(String token) {
        this._token = token;
    }
}

