/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import java.awt.Color;
import java.awt.Component;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import rma.swing.RmaJTable;

public class MultiLineCellRenderer
extends JTextArea
implements TableCellRenderer {
    private static StringBuffer _tooltipBuf = new StringBuffer();

    public MultiLineCellRenderer() {
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setForeground(table.getForeground());
        this.setBackground(table.getBackground());
        this.setFont(table.getFont());
        if (hasFocus) {
            this.setBorder(BorderFactory.createLineBorder(Color.black, 1));
            if (table.isCellEditable(row, column)) {
                this.setForeground(UIManager.getColor("Table.focusCellForeground"));
                this.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.setBorder(new EmptyBorder(1, 2, 1, 2));
        }
        String s = "";
        if (value != null) {
            s = value.toString();
        }
        this.setText(s);
        if (!table.isCellEditable(row, column) && ((RmaJTable)table).isEditable()) {
            this.setBackground(UIManager.getColor("TextField.disabledBackground"));
        } else {
            RmaJTable rtbl = (RmaJTable)table;
            this.setBackground(rtbl.getCellBackground(row, column));
        }
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        }
        return this;
    }

    @Override
    public String getToolTipText() {
        StringTokenizer tokenizer = new StringTokenizer(this.getText(), "\n");
        _tooltipBuf.setLength(0);
        _tooltipBuf.append("<html>");
        while (tokenizer.hasMoreTokens()) {
            _tooltipBuf.append(tokenizer.nextToken());
            if (!tokenizer.hasMoreTokens()) continue;
            _tooltipBuf.append("<BR>");
        }
        _tooltipBuf.append("</html>");
        String toolTipText = _tooltipBuf.toString();
        return toolTipText;
    }
}

