/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import rma.swing.DefaultJPanel;
import rma.swing.PrintPreview;
import rma.swing.table.HeaderFooterPrintSetupPanel;
import rma.swing.table.PagePrintSetupPanel;
import rma.swing.table.PrintPropertiesDlg;
import rma.swing.table.TablePrintManager;
import rma.swing.table.TablePrintProperties;
import rma.swing.table.TitlePageSetupPanel;

public class MultiTablePrintManager
implements Pageable,
Printable {
    Date m_printDate = null;
    TablePrintProperties m_properties = new TablePrintProperties();
    protected List m_tables = new ArrayList();
    PageFormat m_pageFormat = null;
    int m_numPages = -1;
    protected List m_printManagers = new ArrayList();
    protected int m_totalTableHeight = 0;
    protected int m_totalTableWidth = 0;
    int m_tableOffsetY = 0;
    int m_tableOffsetX = 0;
    private static final int NUM_VISIBLE_ROWS_PER_PAGE = 5;
    JList m_headerList;
    JList m_footerList;
    JList m_titleList;
    JList m_subTitleList;
    JList m_remarksList;
    JList m_rightHeaderList;
    JList m_leftHeaderList;
    JList m_rightFooterList;
    JList m_leftFooterList;
    int m_headerHeight = 0;
    int m_footerHeight = 0;
    int m_titleHeight = 0;
    int m_subTitleHeight = 0;
    int m_remarksTitleHeight = 0;

    public MultiTablePrintManager() {
        this.m_properties.scaleColumnsToPage = false;
        this.m_properties.orientation = TablePrintProperties.LANDSCAPE;
        this.m_headerList = new JList();
        this.m_footerList = new JList();
        this.m_titleList = new JList();
        this.m_subTitleList = new JList();
        this.m_remarksList = new JList();
        this.m_rightHeaderList = new JList();
        this.m_leftHeaderList = new JList();
        this.m_rightFooterList = new JList();
        this.m_leftFooterList = new JList();
    }

    public MultiTablePrintManager(List tables) {
        this();
        this.setTables(tables);
    }

    public MultiTablePrintManager(JTable[] tables) {
        this();
        ArrayList l = new ArrayList();
        this.setTables(Arrays.asList(tables));
    }

    public TablePrintProperties getPrintProperties() {
        return this.m_properties;
    }

    public void setPrintProperties(TablePrintProperties properties) {
        this.m_properties = properties;
    }

    protected List getPrintManagers() {
        return this.m_printManagers;
    }

    public int getNumVisibleRowsPerPage() {
        return 5;
    }

    public void addTables(List tables) {
        if (tables != null) {
            for (int i = 0; i < tables.size(); ++i) {
                Object obj = tables.get(i);
                if (obj == null || !(obj instanceof JTable)) continue;
                this.m_tables.add(obj);
                TablePrintManager pm = new TablePrintManager((JTable)obj);
                TablePrintProperties tpp = new TablePrintProperties();
                this.m_properties.copyInto(tpp);
                tpp.orientation = TablePrintProperties.PORTRAIT;
                tpp.subTitle = "";
                tpp.title = "";
                tpp.footer = "";
                tpp.header = "";
                pm.setPrintProperties(tpp);
                this.m_printManagers.add(pm);
            }
        }
    }

    public void setTables(List tables) {
        this.m_printManagers = new ArrayList();
        this.m_tables = new ArrayList();
        this.addTables(tables);
    }

    @Override
    public int getNumberOfPages() {
        if (this.m_numPages != -1) {
            return this.m_numPages;
        }
        int numPages = 0;
        for (int i = 0; i < this.m_printManagers.size(); ++i) {
            int numTablePages = ((TablePrintManager)this.m_printManagers.get(i)).getNumberOfPages();
            numPages = Math.max(numPages, numTablePages);
        }
        this.m_numPages = numPages;
        return numPages;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) {
        if (this.m_pageFormat == null) {
            this.m_pageFormat = new PageFormat();
        }
        this.m_pageFormat.setOrientation(this.m_properties.orientation == TablePrintProperties.PORTRAIT ? 1 : 0);
        return this.m_pageFormat;
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this;
    }

    public void printFooter(Graphics g, PageFormat pageFormat, int pageIndex) {
        if (this.m_footerHeight > 0) {
            Rectangle rect;
            Graphics graphics = g.create();
            this.replacePageCodes(this.m_footerList, this.m_properties.footer, pageIndex + 1);
            this.replacePageCodes(this.m_rightFooterList, this.m_properties.rightFooter, pageIndex + 1, 4);
            this.replacePageCodes(this.m_leftFooterList, this.m_properties.leftFooter, pageIndex + 1, 2);
            double footerScale = 1.0;
            int leftFooterWidth = this.m_leftFooterList.getPreferredSize().width;
            int rightFooterWidth = this.m_rightFooterList.getPreferredSize().width;
            int centerFooterWidth = this.m_footerList.getPreferredSize().width;
            int preferredFooterWidth = centerFooterWidth + rightFooterWidth + leftFooterWidth;
            if ((double)preferredFooterWidth > pageFormat.getImageableWidth()) {
                footerScale = pageFormat.getImageableWidth() / (double)preferredFooterWidth;
            }
            ((Graphics2D)graphics).translate(0.0, pageFormat.getImageableHeight() - (double)this.m_footerHeight);
            boolean xTranslate = false;
            ((Graphics2D)graphics).scale(footerScale, footerScale);
            if (this.m_properties.footer != null && this.m_properties.footer.length() > 0) {
                rect = new Rectangle(0, 0, (int)pageFormat.getImageableWidth(), this.m_footerHeight);
                this.m_footerList.setBounds(rect);
                this.m_footerList.paint(graphics);
            }
            if (this.m_properties.leftFooter != null && this.m_properties.leftFooter.length() > 0) {
                rect = new Rectangle(0, 0, (int)(pageFormat.getImageableWidth() - (double)centerFooterWidth) / 2, this.m_footerHeight);
                this.m_leftFooterList.setOpaque(false);
                this.m_leftFooterList.setBounds(rect);
                this.m_leftFooterList.print(graphics);
            }
            if (this.m_properties.rightFooter != null && this.m_properties.rightFooter.length() > 0) {
                double leftTranslate = pageFormat.getImageableWidth() - (double)rightFooterWidth;
                ((Graphics2D)graphics).translate(leftTranslate, 0.0);
                rect = new Rectangle(0, 0, rightFooterWidth, this.m_footerHeight);
                this.m_rightFooterList.setBounds(rect);
                this.m_rightFooterList.print(graphics);
                ((Graphics2D)graphics).translate(-leftTranslate, 0.0);
            }
            graphics.dispose();
        }
    }

    public void printHeader(Graphics g, PageFormat pageFormat, int pageIndex) {
        if (this.m_headerHeight > 0) {
            Rectangle rect;
            Graphics graphics = g.create();
            this.replacePageCodes(this.m_headerList, this.m_properties.header, pageIndex + 1);
            this.replacePageCodes(this.m_rightHeaderList, this.m_properties.rightHeader, pageIndex + 1, 4);
            this.replacePageCodes(this.m_leftHeaderList, this.m_properties.leftHeader, pageIndex + 1, 2);
            double headerScale = 1.0;
            int leftHeaderWidth = this.m_leftHeaderList.getPreferredSize().width;
            int rightHeaderWidth = this.m_rightHeaderList.getPreferredSize().width;
            int centerHeaderWidth = this.m_headerList.getPreferredSize().width;
            int preferredHeaderWidth = leftHeaderWidth + rightHeaderWidth + centerHeaderWidth;
            if ((double)preferredHeaderWidth > pageFormat.getImageableWidth()) {
                headerScale = pageFormat.getImageableWidth() / (double)preferredHeaderWidth;
            } else if ((double)preferredHeaderWidth < pageFormat.getImageableWidth()) {
                // empty if block
            }
            boolean xTranslate = false;
            ((Graphics2D)graphics).scale(headerScale, headerScale);
            if (this.m_properties.header != null && this.m_properties.header.length() > 0) {
                rect = new Rectangle(0, 0, (int)pageFormat.getImageableWidth(), this.m_headerHeight);
                this.m_headerList.setBounds(rect);
                this.m_headerList.paint(graphics);
            }
            if (this.m_properties.leftHeader != null && this.m_properties.leftHeader.length() > 0) {
                rect = new Rectangle(0, 0, (int)(pageFormat.getImageableWidth() - (double)centerHeaderWidth) / 2, this.m_headerHeight);
                this.m_leftHeaderList.setBounds(rect);
                this.m_leftHeaderList.paint(graphics);
            }
            if (this.m_properties.rightHeader != null && this.m_properties.rightHeader.length() > 0) {
                double leftTranslate = pageFormat.getImageableWidth() - (double)rightHeaderWidth;
                ((Graphics2D)graphics).translate(leftTranslate, 0.0);
                rect = new Rectangle(0, 0, rightHeaderWidth, this.m_headerHeight);
                this.m_rightHeaderList.setBounds(rect);
                this.m_rightHeaderList.paint(graphics);
                ((Graphics2D)graphics).translate(-leftTranslate, 0.0);
            }
            graphics.dispose();
        }
    }

    protected Point getStartPoint(JTable table, PageFormat pageFormat, int xOffset, int yOffset) {
        double scalex;
        double scale = 1.0;
        Point point = new Point();
        Rectangle rect = this.computeTableBounds(table);
        double scaley = pageFormat.getImageableHeight() / (double)this.m_totalTableHeight;
        scale = Math.min(scaley, scalex = pageFormat.getImageableWidth() / (double)this.m_totalTableWidth);
        if (scale > 1.0) {
            scale = 1.0;
        }
        point.y = (int)((double)rect.y * scale - (double)yOffset);
        point.x = (int)((double)rect.x * scale - (double)xOffset);
        return point;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (this.m_numPages == -1) {
            this.getNumberOfPages();
        }
        if (pageIndex > this.m_numPages) {
            return 1;
        }
        System.out.println("Printing Page = " + pageIndex);
        int pageExists = 1;
        boolean lastStartX = false;
        boolean lastSstartY = false;
        int totalHeight = 0;
        Color oldColor = graphics.getColor();
        graphics.setColor(Color.blue);
        graphics.setColor(oldColor);
        ((Graphics2D)graphics).translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        if (!this.m_properties.skipFooterOnFirstPage || pageIndex != 0) {
            this.printFooter(graphics, pageFormat, pageIndex);
        }
        if (!this.m_properties.skipHeaderOnFirstPage || pageIndex != 0) {
            this.printHeader(graphics, pageFormat, pageIndex);
        }
        if (this.m_remarksTitleHeight > 0) {
            double remarksScale = 1.0;
            if ((double)this.m_remarksList.getPreferredSize().width > pageFormat.getImageableWidth()) {
                remarksScale = pageFormat.getImageableWidth() / (double)(this.m_remarksList.getPreferredSize().width + 100);
            }
            double bottomOffset = pageFormat.getImageableHeight() - (double)this.m_remarksTitleHeight;
            if (!this.m_properties.skipFooterOnFirstPage || pageIndex != 0) {
                bottomOffset -= (double)this.m_footerHeight;
            }
            ((Graphics2D)graphics).translate(0.0, bottomOffset);
            Dimension d = this.m_remarksList.getPreferredSize();
            Rectangle rect = new Rectangle(0, 0, (int)(pageFormat.getImageableWidth() * 1.0 / remarksScale), d.height);
            this.m_remarksList.setBounds(rect);
            graphics.setClip(rect);
            ((Graphics2D)graphics).scale(remarksScale, remarksScale);
            this.m_remarksList.paint(graphics);
            ((Graphics2D)graphics).scale(1.0 / remarksScale, 1.0 / remarksScale);
            ((Graphics2D)graphics).translate(0.0, -bottomOffset);
        }
        if (!this.m_properties.skipHeaderOnFirstPage || pageIndex != 0) {
            graphics.translate(0, this.m_headerHeight);
        }
        if (this.m_titleHeight > 0) {
            this.printList((Graphics2D)graphics, pageFormat, this.m_titleList);
        }
        if (this.m_subTitleHeight > 0) {
            this.printList((Graphics2D)graphics, pageFormat, this.m_subTitleList);
        }
        ((Graphics2D)graphics).translate(-pageFormat.getImageableX(), -pageFormat.getImageableY());
        for (int i = 0; i < this.m_tables.size(); ++i) {
            JTable table = (JTable)this.m_tables.get(i);
            Point p = this.getStartPoint(table, pageFormat, this.m_tableOffsetX, this.m_tableOffsetY);
            int startY = p.y;
            int startX = p.x;
            TablePrintManager tm = (TablePrintManager)this.m_printManagers.get(i);
            PageFormat subPageFormat = tm.getPageFormat(pageIndex);
            Graphics g = graphics.create();
            g.translate((int)((double)startX + pageFormat.getImageableX()), (int)((double)startY + pageFormat.getImageableY()));
            int iWidth = (int)subPageFormat.getImageableWidth();
            int iHeight = (int)subPageFormat.getImageableHeight();
            int results = tm.print(g, tm.getPageFormat(pageIndex), pageIndex);
            if (results == 0) {
                pageExists = 0;
                totalHeight = (int)((double)totalHeight + subPageFormat.getImageableHeight());
            }
            g.dispose();
        }
        return pageExists;
    }

    public void printTables() {
        if (!this.showPropertiesDialog()) {
            return;
        }
        this.initialize();
        PrinterJob prnJob = null;
        try {
            prnJob = PrinterJob.getPrinterJob();
            prnJob.setPageable(this);
            if (!prnJob.printDialog()) {
                return;
            }
            prnJob.print();
        }
        catch (PrinterException e) {
            e.printStackTrace();
            System.err.println("Printing error: " + e.toString());
        }
    }

    public void printPreview() {
        if (!this.showPropertiesDialog("Preview")) {
            return;
        }
        this.initialize();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                new PrintPreview((Frame)null, (Printable)MultiTablePrintManager.this, "Print Preview");
            }
        });
        thread.start();
    }

    protected void initializeBounds() {
        Rectangle unionRect = null;
        for (int i = 0; i < this.m_tables.size(); ++i) {
            JTable table = (JTable)this.m_tables.get(i);
            Rectangle rect = this.computeTableBounds(table);
            unionRect = unionRect == null ? rect : unionRect.union(rect);
        }
        this.m_totalTableWidth = (int)unionRect.getWidth();
        this.m_totalTableHeight = (int)unionRect.getHeight();
    }

    protected void initialize() {
        this.initializeBounds();
        PageFormat multiPageFormat = this.getPageFormat(0);
        this.parseString(this.m_titleList, this.m_properties.title, 0, this.m_properties.titleFont);
        this.parseString(this.m_subTitleList, this.m_properties.subTitle, 2, this.m_properties.subTitleFont);
        this.parseString(this.m_headerList, this.m_properties.header);
        this.parseString(this.m_footerList, this.m_properties.footer);
        this.parseString(this.m_remarksList, this.m_properties.remarksTitle, 0, this.m_properties.remarksFont);
        this.parseString(this.m_leftFooterList, this.m_properties.leftFooter, 2, null);
        this.parseString(this.m_rightFooterList, this.m_properties.rightFooter, 4, null);
        this.parseString(this.m_leftHeaderList, this.m_properties.leftHeader, 2, null);
        this.parseString(this.m_rightHeaderList, this.m_properties.rightHeader, 4, null);
        this.m_titleHeight = this.m_titleList.getPreferredSize().height;
        this.m_subTitleHeight = this.m_subTitleList.getPreferredSize().height;
        this.m_headerHeight = Math.max(Math.max(this.m_headerList.getPreferredSize().height, this.m_leftHeaderList.getPreferredSize().height), this.m_rightHeaderList.getPreferredSize().height);
        this.m_footerHeight = Math.max(Math.max(this.m_footerList.getPreferredSize().height, this.m_leftFooterList.getPreferredSize().height), this.m_leftFooterList.getPreferredSize().height);
        this.m_remarksTitleHeight = this.m_remarksList.getPreferredSize().height;
        double tablePrintableHeight = multiPageFormat.getImageableHeight();
        double tablePrintableWidth = multiPageFormat.getImageableWidth();
        tablePrintableHeight -= (double)(this.m_titleHeight + this.m_subTitleHeight + this.m_headerHeight + this.m_footerHeight + this.m_remarksTitleHeight);
        this.m_tableOffsetX = Integer.MAX_VALUE;
        this.m_tableOffsetY = Integer.MAX_VALUE;
        for (int i = 0; i < this.m_tables.size(); ++i) {
            Paper p = new Paper();
            PageFormat pf = new PageFormat();
            JTable table = (JTable)this.m_tables.get(i);
            Rectangle r = this.computeTableBounds(table);
            this.m_tableOffsetX = Math.min(r.x, this.m_tableOffsetX);
            this.m_tableOffsetY = Math.min(r.y, this.m_tableOffsetY);
            int width = 0;
            int height = 0;
            width = (double)this.m_totalTableWidth < tablePrintableWidth ? r.width + 1 : (int)(tablePrintableWidth * (double)r.width / (double)this.m_totalTableWidth);
            height = (double)this.m_totalTableHeight < tablePrintableHeight ? r.height + 1 : (int)(tablePrintableHeight * (double)r.height / (double)this.m_totalTableHeight);
            width = Math.min(width, r.width + 1);
            height = Math.min(height, r.height + 1);
            p.setSize(width, height);
            p.setImageableArea(0.0, 0.0, width, height);
            pf.setPaper(p);
            ((TablePrintManager)this.m_printManagers.get(i)).setPageFormat(0, pf);
        }
    }

    protected Rectangle computeTableBounds(JTable table) {
        int i;
        Rectangle bounds = new Rectangle(0, 0, 0, 0);
        if (table == null) {
            return bounds;
        }
        Rectangle tableBounds = table.getBounds();
        bounds.x = tableBounds.x;
        bounds.y = tableBounds.y;
        JTableHeader header = table.getTableHeader();
        if (header != null) {
            Rectangle headerBounds = header.getBounds();
            bounds.x = headerBounds.x;
            bounds.y = headerBounds.y;
            bounds.height = headerBounds.height;
        }
        for (i = 0; i < table.getRowCount(); ++i) {
            bounds.height += table.getRowHeight(i);
        }
        for (i = 0; i < table.getColumnCount(); ++i) {
            bounds.width += table.getColumnModel().getColumn(i).getWidth();
        }
        Rectangle parentRect = null;
        if (table.getParent() instanceof JViewport) {
            parentRect = table.getParent().getParent().getBounds();
        }
        if (parentRect == null) {
            return bounds;
        }
        bounds.x = parentRect.x;
        bounds.y = parentRect.y;
        return bounds;
    }

    private void parseString(JList list, String text, int align, Font f) {
        list.setBackground(Color.white);
        list.setForeground(Color.black);
        if (text == null) {
            return;
        }
        StringTokenizer strTok = new StringTokenizer(text, "\n", false);
        DefaultListModel<Object> model = new DefaultListModel<Object>();
        int tokenCount = strTok.countTokens();
        for (int i = 0; i < tokenCount; ++i) {
            model.addElement(strTok.nextElement());
        }
        list.setModel(model);
        DefaultListCellRenderer renderer = new DefaultListCellRenderer();
        renderer.setHorizontalAlignment(align);
        Font oldF = renderer.getFont();
        if (f == null) {
            f = new Font("Dialog", 0, oldF.getSize());
        }
        list.setFont(f);
        list.setCellRenderer(renderer);
    }

    private void parseString(JList list, String text) {
        this.parseString(list, text, 0, null);
    }

    private void replacePageCodes(JList list, String str, int pageNum) {
        this.replacePageCodes(list, str, pageNum, 0);
    }

    private void replacePageCodes(JList list, String str, int pageNum, int align) {
        StringBuffer strBuf = new StringBuffer(str);
        int changeCnt = 0;
        int idx = -1;
        idx = str.indexOf("%p");
        if (idx != -1) {
            strBuf = strBuf.replace(idx, idx + "%p".length(), Integer.toString(pageNum));
            str = strBuf.toString();
            ++changeCnt;
        }
        if ((idx = str.indexOf("%n")) != -1) {
            strBuf = strBuf.replace(idx, idx + "%n".length(), Integer.toString(this.getNumberOfPages()));
            str = strBuf.toString();
            ++changeCnt;
        }
        if ((idx = str.indexOf("%d")) != -1) {
            if (this.m_printDate == null) {
                this.m_printDate = new Date(System.currentTimeMillis());
            }
            strBuf = strBuf.replace(idx, idx + "%n".length(), this.m_printDate.toString());
            str = strBuf.toString();
            ++changeCnt;
        }
        if (changeCnt == 0) {
            return;
        }
        this.parseString(list, strBuf.toString(), align, null);
    }

    private void printList(Graphics2D g2d, PageFormat pageFormat, JList list) {
        double listScale = 1.0;
        Dimension d = list.getPreferredSize();
        if ((double)d.width > pageFormat.getImageableWidth()) {
            listScale = pageFormat.getImageableWidth() / (double)d.width;
        }
        g2d.scale(listScale, listScale);
        Rectangle rect = new Rectangle(0, 0, (int)pageFormat.getImageableWidth(), d.height);
        list.setBounds(rect);
        g2d.setClip(rect);
        list.paint(g2d);
        g2d.scale(1.0 / listScale, 1.0 / listScale);
        g2d.translate(0, d.height);
    }

    protected boolean showPropertiesDialog() {
        return this.showPropertiesDialog("Print");
    }

    protected boolean showPropertiesDialog(String type) {
        PrintPropertiesDlg dlg;
        HeaderFooterPrintSetupPanel panel2 = new HeaderFooterPrintSetupPanel();
        panel2.setData(this.m_properties);
        PagePrintSetupPanel panel1 = new PagePrintSetupPanel();
        this.m_properties.printSelection = TablePrintProperties.ENTIRE_TABLE;
        panel1.setData(this.m_properties);
        TitlePageSetupPanel panel3 = new TitlePageSetupPanel();
        panel3.setData(this.m_properties);
        Window w = null;
        if (this.m_tables != null && this.m_tables.size() > 0) {
            w = SwingUtilities.windowForComponent((Component)this.m_tables.get(0));
        }
        DefaultJPanel[] panelList = new DefaultJPanel[]{panel1, panel2, panel3};
        if (w instanceof Frame) {
            if (this.m_properties.useDefaultPrintHeader) {
                panel3.setDefaultTitle(((Frame)w).getTitle());
            }
            dlg = new PrintPropertiesDlg((Frame)w, true, "Properties", panelList);
        } else if (w instanceof Dialog) {
            if (this.m_properties.useDefaultPrintHeader) {
                panel3.setDefaultTitle(((Dialog)w).getTitle());
            }
            dlg = new PrintPropertiesDlg((Dialog)w, true, "Properties", panelList);
        } else {
            dlg = new PrintPropertiesDlg((Frame)null, true, "Properties", panelList);
        }
        dlg.setPrintButtonText(type);
        dlg.pack();
        Dimension d = dlg.getPreferredSize();
        if (w != null) {
            dlg.setLocationRelativeTo(w);
        } else {
            Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
            int xLoc = (screenDim.width + d.width) / 2;
            int yLoc = (screenDim.height + d.height) / 2;
            dlg.setLocation(xLoc, yLoc);
        }
        dlg.setVisible(true);
        if (dlg.isCanceled()) {
            return false;
        }
        for (int i = 0; i < this.m_printManagers.size(); ++i) {
            TablePrintManager tpm = (TablePrintManager)this.m_printManagers.get(i);
            TablePrintProperties tpp = tpm.getPrintProperties();
            this.m_properties.copyInto(tpp);
            tpp.orientation = TablePrintProperties.PORTRAIT;
            tpp.subTitle = "";
            tpp.title = "";
            tpp.footer = "";
            tpp.header = "";
            tpp.leftFooter = "";
            tpp.leftHeader = "";
            tpp.rightFooter = "";
            tpp.rightHeader = "";
            tpm.setPrintProperties(tpp);
        }
        return true;
    }
}

