/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import rma.swing.DefaultJPanel;
import rma.swing.RmaImage;
import rma.swing.RmaInsets;
import rma.swing.table.HeaderFooterPrintSetupPanel;
import rma.swing.table.PrintPropertiesDlg;
import rma.swing.table.TablePrintProperties;

public class PagePrintSetupPanel
extends DefaultJPanel {
    JLabel m_orientationLabel = new JLabel();
    JPanel jPanel1 = new JPanel();
    JLabel m_portraitIcon = new JLabel();
    JRadioButton m_portraitRadio = new JRadioButton();
    JLabel m_landscapeIcon = new JLabel();
    JRadioButton m_entireTableRadio = new JRadioButton("Entire Table");
    JRadioButton m_selectedCells = new JRadioButton("Selected Cells");
    JCheckBox m_allColumnsOnPage = new JCheckBox("All columns on one page");
    JCheckBox m_repeatFixedColumns = new JCheckBox("Repeat fixed columns");
    JRadioButton m_landscapeRadio = new JRadioButton();
    JCheckBox m_printAscii = new JCheckBox("ASCII");
    JCheckBox m_printGridLines = new JCheckBox("Gridlines");
    JCheckBox m_headersEveryPage = new JCheckBox("Repeat Headers");
    JCheckBox m_useHeaderBG = new JCheckBox("Use Header Background");
    TablePrintProperties m_properties = null;

    public PagePrintSetupPanel() {
        this.setName("Page");
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.m_portraitRadio.setText("Portrait");
        this.m_portraitRadio.setMnemonic('P');
        this.m_landscapeRadio.setText("Landscape");
        this.m_landscapeRadio.setMnemonic('L');
        this.m_landscapeIcon.setToolTipText("");
        this.m_landscapeIcon.setIcon(RmaImage.getImageIcon("Images/printer/landscape.gif"));
        this.m_portraitIcon.setIcon(RmaImage.getImageIcon("Images/printer/portrait.gif"));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_portraitRadio);
        bg.add(this.m_landscapeRadio);
        this.m_portraitRadio.setSelected(true);
        bg = new ButtonGroup();
        bg.add(this.m_entireTableRadio);
        bg.add(this.m_selectedCells);
        this.m_entireTableRadio.setSelected(true);
        int y = 0;
        this.add((Component)new LabelDivider("Orientation"), new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.jPanel1, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.m_portraitIcon, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 20, 5, 0), 0, 0));
        this.jPanel1.add((Component)this.m_portraitRadio, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(15, 5, 5, 0), 0, 0));
        this.jPanel1.add((Component)this.m_landscapeIcon, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.jPanel1.add((Component)this.m_landscapeRadio, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(15, 5, 5, 5), 0, 0));
        this.add((Component)new LabelDivider("Scaling"), new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.jPanel1 = new JPanel(new GridBagLayout());
        this.add((Component)this.jPanel1, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.INSETS0000, 0, 0));
        this.jPanel1.add((Component)this.m_allColumnsOnPage, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 20, 0, 0), 0, 0));
        this.add((Component)new LabelDivider("Selection"), new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.jPanel1 = new JPanel(new GridBagLayout());
        this.add((Component)this.jPanel1, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.INSETS0000, 0, 0));
        this.jPanel1.add((Component)this.m_entireTableRadio, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 20, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.m_selectedCells, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 0, RmaInsets.INSETS5505, 0, 0));
        this.add((Component)new LabelDivider("Print"), new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.jPanel1 = new JPanel(new GridBagLayout());
        this.add((Component)this.jPanel1, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.INSETS0000, 0, 0));
        this.m_printAscii.setMargin(RmaInsets.INSETS0000);
        this.m_printGridLines.setMargin(RmaInsets.INSETS0000);
        this.m_headersEveryPage.setMargin(RmaInsets.INSETS0000);
        this.m_useHeaderBG.setMargin(RmaInsets.INSETS0000);
        this.jPanel1.add((Component)this.m_printAscii, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 20, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.m_useHeaderBG, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 20, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.m_repeatFixedColumns, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 18, 0, new Insets(5, 20, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.m_headersEveryPage, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 0, RmaInsets.INSETS5505, 0, 0));
        this.jPanel1.add((Component)this.m_printGridLines, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.INSETS5505, 0, 0));
        this.jPanel1 = new JPanel();
        this.add((Component)this.jPanel1, new GridBagConstraints(0, y++, 1, 1, 1.0, 1.0, 18, 1, RmaInsets.INSETS0000, 0, 0));
        this.m_printAscii.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PagePrintSetupPanel.this.m_useHeaderBG.setEnabled(!PagePrintSetupPanel.this.m_printAscii.isSelected());
            }
        });
    }

    public void setData(TablePrintProperties prop) {
        this.m_properties = prop;
    }

    @Override
    public void fillPanel() {
        if (this.m_properties == null) {
            return;
        }
        if (this.m_properties.orientation == TablePrintProperties.PORTRAIT) {
            this.m_portraitRadio.setSelected(true);
        } else {
            this.m_landscapeRadio.setSelected(true);
        }
        if (this.m_properties.printSelection == TablePrintProperties.ENTIRE_TABLE) {
            this.m_entireTableRadio.setSelected(true);
        } else {
            this.m_selectedCells.setSelected(true);
        }
        this.m_allColumnsOnPage.setSelected(this.m_properties.scaleColumnsToPage);
        this.m_printAscii.setSelected(this.m_properties.asciiPrint);
        this.m_useHeaderBG.setEnabled(!this.m_properties.asciiPrint);
        this.m_printGridLines.setSelected(this.m_properties.printGridlines);
        this.m_useHeaderBG.setSelected(this.m_properties.printHeaderBackground);
        this.m_headersEveryPage.setSelected(this.m_properties.repeatHeaders);
        this.m_repeatFixedColumns.setEnabled(this.m_properties.enableFixedColumns);
        if (this.m_properties.enableFixedColumns) {
            this.m_repeatFixedColumns.setSelected(this.m_properties.repeatFixColumns);
        } else {
            this.m_repeatFixedColumns.setSelected(false);
        }
    }

    @Override
    public boolean savePanel() {
        if (this.m_properties == null) {
            return true;
        }
        this.m_properties.scaleColumnsToPage = this.m_allColumnsOnPage.isSelected();
        this.m_properties.orientation = this.m_portraitRadio.isSelected() ? TablePrintProperties.PORTRAIT : TablePrintProperties.LANDSCAPE;
        this.m_properties.repeatHeaders = this.m_headersEveryPage.isSelected();
        this.m_properties.asciiPrint = this.m_printAscii.isSelected();
        this.m_properties.printSelection = this.m_entireTableRadio.isSelected() ? TablePrintProperties.ENTIRE_TABLE : TablePrintProperties.SELECTED_CELLS;
        this.m_properties.printGridlines = this.m_printGridLines.isSelected();
        this.m_properties.printHeaderBackground = this.m_useHeaderBG.isSelected() && this.m_useHeaderBG.isEnabled();
        this.m_properties.repeatFixColumns = this.m_repeatFixedColumns.isEnabled() && this.m_repeatFixedColumns.isSelected();
        return true;
    }

    public void refresh() {
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        PrintPropertiesDlg dlg = new PrintPropertiesDlg((Frame)null, true, new DefaultJPanel[]{new PagePrintSetupPanel(), new HeaderFooterPrintSetupPanel()});
        dlg.setVisible(true);
    }

    private class LabelDivider
    extends JPanel {
        public LabelDivider(String label) {
            this.setLayout(new GridBagLayout());
            this.add((Component)new JLabel(label), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)new JSeparator(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(15, 5, 5, 5), 0, 0));
        }
    }
}

