/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import rma.swing.table.TablePrintProperties;

public class PrintCellRendererPane
extends CellRendererPane {
    private static final Border EMPTY_BORDER = new EmptyBorder(1, 1, 1, 1);
    TablePrintProperties m_printProperties = new TablePrintProperties();

    @Override
    public void paintComponent(Graphics g, Component c2, Container p, int x, int y, int w, int h, boolean shouldValidate) {
        Color oldBackground = null;
        Color oldForeground = null;
        Border border = null;
        if (this.m_printProperties.asciiPrint) {
            oldBackground = c2.getBackground();
            oldForeground = c2.getForeground();
            c2.setForeground(Color.black);
            c2.setBackground(Color.white);
        }
        Color oldColor = g.getColor();
        g.setColor(c2.getBackground());
        g.fillRect(x, y, w + 1, h + 1);
        g.setColor(oldColor);
        if (c2 instanceof JCheckBox) {
            c2 = new JLabel(new CheckBoxIcon(c2.getForeground(), ((JCheckBox)c2).isSelected()));
        } else if (c2 instanceof JComboBox) {
            Object selectedItem = ((JComboBox)c2).getSelectedItem();
            Color fc = ((JComboBox)c2).getForeground();
            c2 = new JLabel(selectedItem == null ? "" : selectedItem.toString());
            c2.setForeground(fc);
        }
        if (c2 instanceof JComponent) {
            border = ((JComponent)c2).getBorder();
            ((JComponent)c2).setBorder(EMPTY_BORDER);
        }
        super.paintComponent(g, c2, p, x, y, w, h, shouldValidate);
        if (oldBackground != null) {
            c2.setBackground(oldBackground);
        }
        if (oldForeground != null) {
            c2.setForeground(oldForeground);
        }
        if (border != null) {
            ((JComponent)c2).setBorder(border);
        }
    }

    public void setPrintProperties(TablePrintProperties p) {
        this.m_printProperties = p;
    }

    private class CheckBoxIcon
    implements Icon {
        Color m_foreground = Color.black;
        boolean m_selected = false;
        static final int csize = 13;

        public CheckBoxIcon(Color foreground, boolean selected) {
            this.m_foreground = foreground;
            this.m_selected = selected;
        }

        @Override
        public void paintIcon(Component c2, Graphics g, int x, int y) {
            if (!this.m_selected) {
                return;
            }
            Color oldColor = g.getColor();
            g.setColor(Color.black);
            g.drawLine(x + 9, y + 3, x + 9, y + 3);
            g.drawLine(x + 8, y + 4, x + 9, y + 4);
            g.drawLine(x + 7, y + 5, x + 9, y + 5);
            g.drawLine(x + 6, y + 6, x + 8, y + 6);
            g.drawLine(x + 3, y + 7, x + 7, y + 7);
            g.drawLine(x + 4, y + 8, x + 6, y + 8);
            g.drawLine(x + 5, y + 9, x + 5, y + 9);
            g.drawLine(x + 3, y + 5, x + 3, y + 5);
            g.drawLine(x + 3, y + 6, x + 4, y + 6);
            g.setColor(oldColor);
        }

        @Override
        public int getIconWidth() {
            return 13;
        }

        @Override
        public int getIconHeight() {
            return 13;
        }
    }
}

