/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JTabbedPane;
import javax.swing.event.EventListenerList;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.DefaultJPanel;
import rma.swing.RmaJDialog;
import rma.util.RMAIO;

public class PrintPropertiesDlg
extends RmaJDialog
implements ButtonCmdPanelListener {
    private DefaultJPanel[] _panels = null;
    private boolean _canceled = false;
    private ButtonCmdPanel _cmdPanel;
    EventListenerList listenerList = new EventListenerList();
    boolean fComponentsAdjusted = false;

    public PrintPropertiesDlg(Frame parent, boolean model, DefaultJPanel[] panels) {
        super(parent, model);
        this.createComponents(panels);
    }

    public PrintPropertiesDlg(Frame parent, boolean model, String title, DefaultJPanel[] panels) {
        this(parent, model, panels);
        this.setTitle(title);
    }

    public PrintPropertiesDlg(Dialog parent, boolean model, DefaultJPanel[] panels) {
        super(parent, model);
        this.createComponents(panels);
    }

    public PrintPropertiesDlg(Dialog parent, boolean model, String title, DefaultJPanel[] panels) {
        this(parent, model, panels);
        this.setTitle(title);
    }

    private void createComponents(DefaultJPanel[] panels) {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(410, 395);
        if (panels != null && panels.length > 0) {
            if (panels.length == 1) {
                this.getContentPane().add((Component)panels[0], new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            } else {
                JTabbedPane tabPane = new JTabbedPane();
                this.getContentPane().add((Component)tabPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
                for (int i = 0; i < panels.length; ++i) {
                    tabPane.addTab(panels[i].getName(), panels[i]);
                }
            }
            this._panels = panels;
            for (int i = 0; i < panels.length; ++i) {
                panels[i].fillPanel();
            }
        } else {
            RMAIO.postWarning(this, "There are no panels to display");
            System.out.println("There are no panels to display");
        }
        this._cmdPanel = new ButtonCmdPanel(132);
        this.getContentPane().add((Component)this._cmdPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 16, 2, new Insets(0, 0, 5, 5), 0, 0));
        this._cmdPanel.setApplyEnabled(true);
        this._cmdPanel.addCmdPanelListener(this);
        this.setTitle("Print Properties Setup");
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        Dimension d = this.getPreferredSize();
        this.setSize(d.width, d.height);
        this.setDefaultSize(d.width, d.height);
    }

    @Override
    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets ins = this.getInsets();
        this.setSize(ins.left + ins.right + d.width, ins.top + ins.bottom + d.height);
        Component[] components = this.getContentPane().getComponents();
        for (int i = 0; i < components.length; ++i) {
            Point p = components[i].getLocation();
            p.translate(ins.left, ins.top);
            components[i].setLocation(p);
        }
        this.fComponentsAdjusted = true;
    }

    public PrintPropertiesDlg(String title) {
        this.setTitle(title);
    }

    public static void main(String[] args) {
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setLocationRelativeTo(this.getParent());
        } else {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                this.listenerList.remove((Class)listeners[i], (ActionListener)listeners[i + 1]);
            }
        }
        super.setVisible(b);
    }

    void PrintPropertiesDlg_WindowClosing(WindowEvent event) {
        this.dispose();
        this.buttonCancelActionPerformed();
    }

    @Override
    public void buttonCmdActionPerformed(ActionEvent event) {
        if (event.getID() == 128) {
            this.buttonPrintActionPerformed();
        } else if (event.getID() == 4) {
            this.buttonCancelActionPerformed();
        }
    }

    private void buttonApplyActionPerformed() {
        if (this._panels == null) {
            return;
        }
        boolean success = true;
        for (int i = 0; i < this._panels.length; ++i) {
            success &= this._panels[i].savePanel();
        }
        if (!success) {
            return;
        }
        this.fireActionPerformed();
    }

    private void buttonPrintActionPerformed() {
        if (this._panels == null) {
            return;
        }
        boolean success = true;
        for (int i = 0; i < this._panels.length; ++i) {
            success &= this._panels[i].savePanel();
        }
        if (!success) {
            return;
        }
        this._canceled = false;
        this.fireActionPerformed();
        this.setVisible(false);
        this.dispose();
    }

    private void buttonCancelActionPerformed() {
        this._canceled = true;
        this.setVisible(false);
        this.dispose();
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public synchronized void addOKListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public synchronized void removeOKListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    protected void fireActionPerformed() {
        Object[] listeners = this.listenerList.getListenerList();
        Object e = null;
        ActionEvent event = new ActionEvent(this, 0, "Button OK/Apply Pressed");
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(event);
        }
    }

    public void setPrintButtonText(String type) {
        this._cmdPanel.getButton(128).setText(type);
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == PrintPropertiesDlg.this) {
                PrintPropertiesDlg.this.PrintPropertiesDlg_WindowClosing(event);
            }
        }
    }
}

