/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import hec.data.DataSetException;
import hec.data.ParamDouble;
import hec.data.ParamInteger;
import hec.data.Parameter;
import hec.data.Units;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreeCellEditor;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDescriptionField;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJTable;
import rma.util.RMAIO;

public class RmaCellEditor
extends AbstractCellEditor
implements TableCellEditor,
TreeCellEditor {
    protected JComponent editorComponent;
    protected EditorDelegate delegate;
    protected int clickCountToStart = 1;
    protected int _unitSystem;
    protected int _paramScaleId;
    protected double _scaleFactor = 1.0;
    private JTable _table;
    private int _lastRow;
    private int _lastCol;

    public RmaCellEditor() {
    }

    public RmaCellEditor(final JTextField textField) {
        this.editorComponent = textField;
        this.clickCountToStart = 2;
        this.delegate = new EditorDelegate(){

            @Override
            public void setValue(Object value) {
                textField.setText(value != null ? value.toString() : "");
            }

            @Override
            public Object getCellEditorValue() {
                return textField.getText();
            }
        };
        textField.addActionListener(this.delegate);
    }

    public RmaCellEditor(final RmaJDecimalField textField) {
        this.editorComponent = textField;
        this.clickCountToStart = 2;
        this.delegate = new EditorDelegate(){

            @Override
            public void setValue(Object value) {
                if (value instanceof ParamDouble) {
                    this._parameterId = ((ParamDouble)value).getParameterId();
                    if (this._precision != Integer.MIN_VALUE && !textField.useDecimalFormatForParameters()) {
                        textField.setPrecision(this._precision);
                    }
                    this._dataUnitSystem = ((ParamDouble)value).getUnitSystem();
                    textField.setValue((ParamDouble)value);
                    textField.setDisplayScaleFactor(RmaCellEditor.this._paramScaleId, RmaCellEditor.this._scaleFactor);
                    textField.setDisplayUnitsSystem(RmaCellEditor.this._unitSystem);
                    return;
                }
                this._parameterId = -1;
                textField.setText(value != null ? value.toString() : "");
            }

            @Override
            public Object getCellEditorValue() {
                if (this._parameterId == -1) {
                    return textField.getText();
                }
                ParamDouble pd = textField.getParamValue();
                textField.setModified(false);
                return pd;
            }
        };
        textField.addActionListener(this.delegate);
    }

    public RmaCellEditor(final RmaJIntegerField textField) {
        this.editorComponent = textField;
        this.clickCountToStart = 2;
        this.delegate = new EditorDelegate(){

            @Override
            public void setValue(Object value) {
                if (value instanceof ParamInteger) {
                    if (RmaCellEditor.this._unitSystem == ((ParamInteger)value).getUnitSystem()) {
                        textField.setText(value.toString());
                        return;
                    }
                    ParamInteger pd = (ParamInteger)value;
                    this._dataUnitSystem = pd.getUnitSystem();
                    this._parameterId = pd.getParameterId();
                    String beforeUnitSystem = Parameter.getUnitsStringForSystem(this._parameterId, this._dataUnitSystem);
                    String afterUnitSystem = Parameter.getUnitsStringForSystem(this._parameterId, RmaCellEditor.this._unitSystem);
                    try {
                        double[] x = new double[]{pd.getValue()};
                        Units.convertUnits(x, beforeUnitSystem, afterUnitSystem);
                        textField.setText(RMAIO.setPrecision2(x[0], 0));
                        return;
                    }
                    catch (DataSetException e) {
                        System.out.println("EXCEPTION <RmaCellRenderer.getTableCellRendererComponent()> : " + e.getMessage());
                    }
                }
                textField.setText(value != null ? value.toString() : "");
            }

            @Override
            public Object getCellEditorValue() {
                ParamInteger pd;
                String txt = textField.getText();
                if (this._parameterId == Integer.MIN_VALUE) {
                    return txt;
                }
                int value = RMAIO.parseInt(txt);
                if (RmaCellEditor.this._unitSystem == this._dataUnitSystem) {
                    ParamInteger pd2 = new ParamInteger(value, this._parameterId);
                    pd2.setUnitSystem(this._dataUnitSystem);
                    return pd2;
                }
                String beforeUnitSystem = Parameter.getUnitsStringForSystem(this._parameterId, RmaCellEditor.this._unitSystem);
                String afterUnitSystem = Parameter.getUnitsStringForSystem(this._parameterId, this._dataUnitSystem);
                try {
                    double[] x = new double[]{value};
                    Units.convertUnits(x, beforeUnitSystem, afterUnitSystem);
                    String str = RMAIO.setPrecision2(x[0], 0);
                    pd = new ParamInteger(RMAIO.parseInt(str), this._parameterId);
                    pd.setUnitSystem(this._dataUnitSystem);
                }
                catch (DataSetException e) {
                    System.out.println("EXCEPTION <RmaCellRenderer.getTableCellRendererComponent()> : " + e.getMessage());
                    return "";
                }
                this._parameterId = Integer.MIN_VALUE;
                textField.setModified(false);
                return pd;
            }
        };
        textField.addActionListener(this.delegate);
    }

    public RmaCellEditor(final JTextArea textArea, boolean addScrollPane) {
        JComponent comp = textArea;
        if (addScrollPane) {
            JScrollPane sp = new JScrollPane(textArea);
            sp.setHorizontalScrollBarPolicy(31);
            sp.setVerticalScrollBarPolicy(21);
            sp.setBorder(BorderFactory.createLineBorder(Color.black));
            comp = sp;
        }
        this.editorComponent = comp;
        this.clickCountToStart = 2;
        this.delegate = new EditorDelegate(){

            @Override
            public void setValue(Object value) {
                textArea.setText(value != null ? value.toString() : "");
            }

            @Override
            public Object getCellEditorValue() {
                return textArea.getText();
            }
        };
    }

    public RmaCellEditor(final RmaJDescriptionField descField) {
        this.editorComponent = descField;
        this.clickCountToStart = 2;
        this.delegate = new EditorDelegate(){

            @Override
            public void setValue(Object value) {
                descField.setText(value != null ? value.toString() : "");
            }

            @Override
            public Object getCellEditorValue() {
                return descField.getText();
            }
        };
    }

    public RmaCellEditor(final JToggleButton checkBoxOrRadio) {
        this.editorComponent = checkBoxOrRadio;
        this.delegate = new EditorDelegate(){

            @Override
            public void setValue(Object value) {
                boolean selected = false;
                if (value instanceof Boolean) {
                    selected = (Boolean)value;
                } else if (value instanceof String) {
                    selected = value.equals("true");
                }
                checkBoxOrRadio.setSelected(selected);
                if (RmaCellEditor.this._table instanceof RmaJTable) {
                    RmaJTable table = (RmaJTable)RmaCellEditor.this._table;
                    Color c2 = table.getCellBackground(RmaCellEditor.this._lastRow, RmaCellEditor.this._lastCol);
                    checkBoxOrRadio.setBackground(c2);
                }
            }

            @Override
            public Object getCellEditorValue() {
                return checkBoxOrRadio.isSelected();
            }
        };
        checkBoxOrRadio.addActionListener(this.delegate);
    }

    public RmaCellEditor(final JComboBox comboBox) {
        this.editorComponent = comboBox;
        comboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.delegate = new EditorDelegate(){

            @Override
            public void setValue(Object value) {
                comboBox.setSelectedItem(value);
            }

            @Override
            public Object getCellEditorValue() {
                return comboBox.getSelectedItem();
            }

            @Override
            public boolean shouldSelectCell(EventObject anEvent) {
                if (anEvent instanceof MouseEvent) {
                    MouseEvent e = (MouseEvent)anEvent;
                    return e.getID() != 506;
                }
                return true;
            }
        };
        comboBox.addActionListener(this.delegate);
    }

    public RmaCellEditor(final JButton button) {
        this.editorComponent = button;
        this.delegate = new EditorDelegate(){

            @Override
            public void setValue(Object value) {
                if (value != null) {
                    button.setText(value.toString());
                } else {
                    button.setText("");
                }
            }

            @Override
            public Object getCellEditorValue() {
                if (button.getText() == null) {
                    return "";
                }
                return button.getText();
            }

            @Override
            public boolean shouldSelectCell(EventObject anEvent) {
                if (anEvent instanceof MouseEvent) {
                    MouseEvent e = (MouseEvent)anEvent;
                    return e.getID() != 506;
                }
                return true;
            }
        };
    }

    public Component getComponent() {
        return this.editorComponent;
    }

    public Component getEditorComponent() {
        return this.editorComponent;
    }

    public void setDisplayUnitSystem(int unitSystem) {
        this._unitSystem = unitSystem;
        if (this.editorComponent instanceof RmaJDecimalField) {
            ((RmaJDecimalField)this.editorComponent).setDisplayUnitsSystem(unitSystem);
        }
    }

    public int getDisplayUnitSystem() {
        return this._unitSystem;
    }

    public void setDisplayScaleFactor(int paramId, double scale) {
        this._paramScaleId = paramId;
        this._scaleFactor = scale;
    }

    public double getDisplayScaleFactor() {
        return this._scaleFactor;
    }

    public void setClickCountToStart(int count) {
        this.clickCountToStart = count;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    public int getParamScaleId() {
        return this._paramScaleId;
    }

    public int getUnitSystem() {
        return this._unitSystem;
    }

    public void setUnitSystem(int unitSystem) {
        this.setDisplayUnitSystem(unitSystem);
    }

    @Override
    public Object getCellEditorValue() {
        return this.delegate.getCellEditorValue();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return this.delegate.isCellEditable(anEvent);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return this.delegate.shouldSelectCell(anEvent);
    }

    @Override
    public boolean stopCellEditing() {
        return this.delegate.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        this.delegate.cancelCellEditing();
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        String stringValue = tree.convertValueToText(value, isSelected, expanded, leaf, row, false);
        this.delegate.setValue(stringValue);
        return this.editorComponent;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        TableColumn tc;
        this._table = table;
        this._lastRow = row;
        this._lastCol = column;
        if (value instanceof ParamDouble && (tc = table.getColumnModel().getColumn(column)) != null) {
            Component c2;
            TableCellRenderer renderer = tc.getCellRenderer();
            if (renderer == null) {
                renderer = table.getDefaultRenderer(value.getClass());
            }
            if ((c2 = renderer.getTableCellRendererComponent(table, value, isSelected, false, row, column)) instanceof JLabel) {
                String display = ((JLabel)c2).getText();
                int p = this.findPrecision(display);
                if (p > ((ParamDouble)value).getPrecision()) {
                    this.delegate.setPrecision(p);
                } else {
                    this.delegate.setPrecision(((ParamDouble)value).getPrecision());
                }
            }
        }
        this.delegate.setValue(value);
        return this.editorComponent;
    }

    private int findPrecision(String value) {
        int decimal = value.indexOf(".");
        int precision = 0;
        if (decimal >= 0) {
            if (value.indexOf(69) > 0 || value.indexOf(101) > 0) {
                precision = 0;
            } else {
                String trimVal = value.trim();
                precision = trimVal.length() - decimal - 1;
                for (int i = trimVal.length() - 1; i > decimal && trimVal.charAt(i) == '0'; --i) {
                    --precision;
                }
            }
        } else {
            precision = 0;
        }
        return precision;
    }

    @Override
    protected void fireEditingStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CellEditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)listeners[i + 1]).editingStopped(this.changeEvent);
        }
    }

    @Override
    protected void fireEditingCanceled() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CellEditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)listeners[i + 1]).editingCanceled(this.changeEvent);
        }
    }

    public class EditorDelegate
    implements ActionListener,
    ItemListener,
    Serializable {
        protected Object value;
        int _dataUnitSystem;
        int _parameterId = Integer.MIN_VALUE;
        int _precision = Integer.MIN_VALUE;

        public void setPrecision(int p) {
            this._precision = p;
        }

        public Object getCellEditorValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                return ((MouseEvent)anEvent).getClickCount() >= RmaCellEditor.this.clickCountToStart;
            }
            return true;
        }

        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        public boolean startCellEditing(EventObject anEvent) {
            return true;
        }

        public boolean stopCellEditing() {
            RmaCellEditor.this.fireEditingStopped();
            return true;
        }

        public void cancelCellEditing() {
            RmaCellEditor.this.fireEditingCanceled();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RmaCellEditor.this.stopCellEditing();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.stopCellEditing();
        }
    }
}

