/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import hec.data.DataSetException;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.data.Units;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import rma.swing.IParameterScale;
import rma.swing.RmaJTable;
import rma.swing.table.UnitsCellRenderer;
import rma.util.RMAConst;
import rma.util.RMAIO;
import rma.util.logging.MarkingClassLogger;
import rma.util.logging.marking.UnitsLoggingMarker;

public class RmaCellRenderer
implements TableCellRenderer,
Serializable,
UnitsCellRenderer {
    private static final MarkingClassLogger UNITS_LOGGER = MarkingClassLogger.forMarkingClass(UnitsLoggingMarker.class);
    protected static final Color selectionColor = new Color(0, 0, 128);
    protected JComponent component;
    protected ValueProperty value;
    protected Color backgroundColor;
    protected Color foregroundColor;
    protected Color selectedBackgroundColor;
    protected Color selectedForegroundColor;
    static Border noFocusBorder = new EmptyBorder(1, 2, 1, 2);
    protected static Font _defaultFont;
    protected static Font _numberFont;
    protected int _unitSystem;
    protected boolean _ignoreParameterRounding = false;
    protected Hashtable _columnScalingList = new Hashtable();
    protected double _scaleFactor = 1.0;
    protected int _paramIdForScaling = Integer.MIN_VALUE;
    protected static final boolean DEBUG;
    protected Border _focusedCellBorder = BorderFactory.createLineBorder(Color.black, 2);
    protected String _missingString = "";
    protected boolean _showComma = false;
    protected DecimalFormat _formater = (DecimalFormat)DecimalFormat.getInstance();
    private Color _alternateRowBackground = Color.LIGHT_GRAY;

    public RmaCellRenderer() {
        this(new JLabel());
    }

    public RmaCellRenderer(JLabel x) {
        this.component = x;
        x.setOpaque(true);
        this.value = new ValueProperty(){

            @Override
            public void setValue(Object x1) {
                if (x1 == null) {
                    x1 = "";
                }
                super.setValue(x1);
                if (x1 instanceof Icon) {
                    ((JLabel)RmaCellRenderer.this.component).setIcon((Icon)x1);
                    ((JLabel)RmaCellRenderer.this.component).setText("");
                } else {
                    ((JLabel)RmaCellRenderer.this.component).setText(x1.toString());
                    ((JLabel)RmaCellRenderer.this.component).setIcon(null);
                }
            }
        };
        _defaultFont = UIManager.getFont("TextField.font");
        _numberFont = new Font("monospaced", _defaultFont.getStyle(), _defaultFont.getSize());
        x.setFont(_defaultFont);
    }

    public RmaCellRenderer(JButton x) {
        this.component = x;
        this.value = new ValueProperty(){

            @Override
            public void setValue(Object x1) {
                if (x1 == null) {
                    x1 = "";
                }
                super.setValue(x1);
                ((JButton)RmaCellRenderer.this.component).setText(x1.toString());
            }
        };
        _defaultFont = UIManager.getFont("TextField.font");
        _numberFont = new Font("monospaced", _defaultFont.getStyle(), _defaultFont.getSize());
        x.setFont(_defaultFont);
    }

    public RmaCellRenderer(JCheckBox x) {
        this.component = x;
        this.value = new ValueProperty(){

            @Override
            public void setValue(Object x1) {
                if (x1 == null) {
                    x1 = "";
                }
                super.setValue(x1);
                if (x1 instanceof Boolean) {
                    ((JCheckBox)RmaCellRenderer.this.component).setSelected((Boolean)x1);
                } else if (x1 instanceof String) {
                    Boolean b = Boolean.valueOf((String)x1);
                    ((JCheckBox)RmaCellRenderer.this.component).setSelected(b);
                } else {
                    ((JCheckBox)RmaCellRenderer.this.component).setSelected(false);
                }
            }
        };
        _defaultFont = UIManager.getFont("TextField.font");
        _numberFont = new Font("monospaced", _defaultFont.getStyle(), _defaultFont.getSize());
        x.setFont(_defaultFont);
    }

    public void setIgnoreParameterRounding(boolean ignore) {
        this._ignoreParameterRounding = ignore;
    }

    public boolean ignoreParameterRounding() {
        return this._ignoreParameterRounding;
    }

    public void setBackgroundColor(Color newColor) {
        this.backgroundColor = newColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setForegroundColor(Color newColor) {
        this.foregroundColor = newColor;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setSelectedBackgroundColor(Color newColor) {
        this.selectedBackgroundColor = newColor;
    }

    public Color getSelectedBackgroundColor() {
        return this.selectedBackgroundColor;
    }

    public void setSelectedForegroundColor(Color newColor) {
        this.selectedForegroundColor = newColor;
    }

    public Color getSelectedForegroundColor() {
        return this.selectedForegroundColor;
    }

    public void setToolTipText(String text) {
        if (this.component != null) {
            this.component.setToolTipText(text);
        }
    }

    public Component getComponent() {
        return this.component;
    }

    public void setHorizontalAlignment(int align) {
        if (this.component instanceof JLabel) {
            ((JLabel)this.component).setHorizontalAlignment(align);
        }
    }

    public int getHorizontalAlignment() {
        if (this.component instanceof JLabel) {
            return ((JLabel)this.component).getHorizontalAlignment();
        }
        if (this.component instanceof JCheckBox) {
            return 0;
        }
        return 4;
    }

    public void setIcon(Icon value) {
        if (this.component instanceof JLabel) {
            ((JLabel)this.component).setIcon(value);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        ParamDouble pd;
        if (Number.class.isAssignableFrom(table.getColumnClass(column))) {
            this.component.setFont(_numberFont);
        } else {
            this.component.setFont(_defaultFont);
        }
        if (table.isFontSet()) {
            this.component.setFont(table.getFont());
        }
        if (isSelected) {
            this.renderSelectedCellComponent(table, value, hasFocus, row, column);
        } else {
            this.renderCellComponent(table, value, hasFocus, row, column);
        }
        if (value instanceof ParamDouble && !RMAConst.isValidValue((pd = (ParamDouble)value).getValue())) {
            this.value.setValue(this._missingString);
            return this.component;
        }
        if (value instanceof ParamDouble && ((ParamDouble)value).getParameterId() == -1) {
            pd = (ParamDouble)value;
            if (pd.getPrecision() == -2 || pd.getPrecision() == -1) {
                this._formater.setMaximumFractionDigits(340);
                this._formater.setMinimumFractionDigits(0);
                this._formater.setGroupingUsed(this._showComma);
                this.value.setValue(this._formater.format(pd.getValue()));
            } else {
                this._formater.setMaximumFractionDigits(pd.getPrecision());
                this._formater.setMinimumFractionDigits(pd.getPrecision());
                this._formater.setGroupingUsed(this._showComma);
                this.value.setValue(this._formater.format(pd.getValue()));
            }
            return this.component;
        }
        if (value instanceof ParamDouble && this._unitSystem != ((ParamDouble)value).getUnitSystem()) {
            String afterUnitSystem;
            String beforeUnitSystem;
            pd = (ParamDouble)value;
            if (!RMAConst.isValidValue(pd.getValue())) {
                this.value.setValue(this._missingString);
                return this.component;
            }
            int pid = pd.getParameterId();
            try {
                beforeUnitSystem = Parameter.getUnitsStringForSystem(pid, pd.getUnitSystem());
                afterUnitSystem = Parameter.getUnitsStringForSystem(pid, this._unitSystem);
            }
            catch (IllegalArgumentException e) {
                pd = (ParamDouble)value;
                if (pd.getPrecision() == -2 || pd.getPrecision() == -1) {
                    this._formater.setMaximumFractionDigits(340);
                    this._formater.setMinimumFractionDigits(0);
                    this._formater.setGroupingUsed(this._showComma);
                    this.value.setValue(this._formater.format(pd.getValue()));
                } else {
                    this._formater.setMaximumFractionDigits(pd.getPrecision());
                    this._formater.setMinimumFractionDigits(pd.getPrecision());
                    this._formater.setGroupingUsed(this._showComma);
                    this.value.setValue(this._formater.format(pd.getValue()));
                }
                return this.component;
            }
            catch (Exception e) {
                ((MarkingClassLogger.Api)((MarkingClassLogger.Api)UNITS_LOGGER.atInfo()).withCause(e)).log("Error rendering %s for (row,column) = (%s,%s)", pd, row, column);
                this.value.setValue("!error!");
                return this.component;
            }
            try {
                ParamDouble pd2 = null;
                pd2 = !beforeUnitSystem.equals(afterUnitSystem) ? Units.convertUnits(pd, beforeUnitSystem, afterUnitSystem) : new ParamDouble(pd.getValue(), pd.getParameterId(), pd.getUnitSystem(), pd.getPrecision());
                IParameterScale scaleObj = (IParameterScale)this._columnScalingList.get(new Integer(column));
                double scale = 1.0;
                if (scaleObj == null && table instanceof RmaJTable) {
                    Map<Integer, RmaJTable.ParameterScale> scaleMap = ((RmaJTable)table).getDisplayScaleMap();
                    scaleObj = scaleMap.get(new Integer(column));
                }
                scale = scaleObj != null ? (scaleObj.getParamId() == pd.getParameterId() ? scaleObj.getScale() : 1.0) : 1.0;
                if (pd2.getPrecision() == -2 || pd2.getPrecision() == -1) {
                    this._formater.setMaximumFractionDigits(340);
                    this._formater.setMinimumFractionDigits(0);
                    this._formater.setGroupingUsed(this._showComma);
                    this.value.setValue(this._formater.format(pd2.getValue() * scale));
                } else {
                    double multFactor;
                    int errorfactor = 0;
                    if (multFactor > 1.0) {
                        for (multFactor = Units.getScalarFactor(beforeUnitSystem, afterUnitSystem); multFactor > 1.0; multFactor /= 10.0) {
                            ++errorfactor;
                        }
                    } else if (multFactor > 0.0 && multFactor < 1.0) {
                        while (multFactor < 1.0) {
                            ++errorfactor;
                            multFactor *= 10.0;
                        }
                    }
                    int prec = 0;
                    prec = pd2.getPrecision() - errorfactor;
                    if (prec < 0) {
                        prec = pd2.getPrecision();
                    }
                    if (this.ignoreParameterRounding()) {
                        this._formater.setGroupingUsed(this._showComma);
                        this._formater.setMaximumFractionDigits(340);
                        this._formater.setMinimumFractionDigits(0);
                        this.value.setValue(this._formater.format(pd2.getValue() * scale));
                    } else {
                        double val = RMAIO.round(pd2.getValue() * scale, prec);
                        this._formater.setMaximumFractionDigits(pd2.getPrecision());
                        this._formater.setMinimumFractionDigits(pd2.getPrecision());
                        this._formater.setGroupingUsed(this._showComma);
                        this.value.setValue(this._formater.format(val));
                    }
                }
                return this.component;
            }
            catch (DataSetException e) {
                System.out.println("EXCEPTION <RmaCellRenderer.getTableCellRendererComponent()> : " + e.getMessage());
            }
        } else if (value instanceof ParamDouble && this._unitSystem == ((ParamDouble)value).getUnitSystem()) {
            pd = (ParamDouble)value;
            IParameterScale scaleObj = (ParameterScale)this._columnScalingList.get(new Integer(column));
            double scale = 1.0;
            if (scaleObj == null && table instanceof RmaJTable) {
                Map<Integer, RmaJTable.ParameterScale> scaleMap = ((RmaJTable)table).getDisplayScaleMap();
                scaleObj = scaleMap.get(new Integer(column));
            }
            scale = scaleObj != null ? (scaleObj.getParamId() == pd.getParameterId() ? scaleObj.getScale() : 1.0) : 1.0;
            if (pd.getPrecision() == -2 || pd.getPrecision() == -1) {
                this._formater.setMaximumFractionDigits(340);
                this._formater.setMinimumFractionDigits(0);
                this._formater.setGroupingUsed(this._showComma);
                this.value.setValue(this._formater.format(pd.getValue() * scale));
            } else {
                this._formater.setMaximumFractionDigits(pd.getPrecision());
                this._formater.setMinimumFractionDigits(pd.getPrecision());
                this._formater.setGroupingUsed(this._showComma);
                this.value.setValue(this._formater.format(pd.getValue() * scale));
            }
            return this.component;
        }
        if (table instanceof RmaJTable && ((RmaJTable)table).getAutoRowHeaders() && column == 0) {
            this.value.setValue(Integer.toString(row + ((RmaJTable)table).getAutoRowHeaderOffset()));
            if (this.component instanceof JLabel) {
                ((JLabel)this.component).setHorizontalAlignment(0);
            }
        } else {
            this.value.setValue(value);
        }
        return this.component;
    }

    public void setAlternateRowBackground(Color altColor) {
        this._alternateRowBackground = altColor;
    }

    public Color getAlternateRowBackground() {
        return this._alternateRowBackground;
    }

    protected Component renderSelectedCellComponent(JTable table, Object value, boolean hasFocus, int row, int column) {
        if (table instanceof RmaJTable) {
            RmaJTable rmaTable = (RmaJTable)table;
            Font f = rmaTable.getCellFont(row, column);
            if (f != null) {
                this.component.setFont(f);
            }
            if (rmaTable.getRowHeaderEnabled() && column == 0) {
                if (rmaTable.getAutoRowHeaders()) {
                    this.value.setValue(Integer.toString(row + rmaTable.getAutoRowHeaderOffset()));
                    if (this.component instanceof JLabel) {
                        ((JLabel)this.component).setHorizontalAlignment(0);
                    }
                } else {
                    this.value.setValue(value);
                    if (this.component instanceof JLabel) {
                        ((JLabel)this.component).setHorizontalAlignment(2);
                    }
                }
                return this.component;
            }
            this.component.setBorder(null);
            if (this.selectedBackgroundColor == null) {
                this.component.setBackground(table.getSelectionBackground());
            } else {
                this.component.setBackground(this.selectedBackgroundColor);
            }
            Color c2 = rmaTable.getRowForeground(row);
            if (this.selectedForegroundColor == null) {
                if (c2.equals(Color.black)) {
                    this.component.setForeground(table.getSelectionForeground());
                } else {
                    this.component.setForeground(c2);
                }
            } else {
                this.component.setForeground(this.selectedForegroundColor);
            }
            if (hasFocus) {
                if (table.isCellEditable(row, column)) {
                    this.component.setBorder(this._focusedCellBorder);
                    if (c2.equals(Color.black)) {
                        this.component.setForeground(UIManager.getColor("Table.focusCellForeground"));
                    } else {
                        this.component.setForeground(c2);
                    }
                    this.component.setBackground(UIManager.getColor("Table.focusCellBackground"));
                } else {
                    this.component.setBorder(noFocusBorder);
                    if (rmaTable.isEditable()) {
                        // empty if block
                    }
                }
            } else {
                this.component.setBorder(noFocusBorder);
            }
        } else {
            this.component.setBorder(null);
            if (this.selectedBackgroundColor == null) {
                this.component.setBackground(table.getSelectionBackground());
            } else {
                this.component.setBackground(this.selectedBackgroundColor);
            }
            if (this.selectedForegroundColor == null) {
                this.component.setForeground(table.getSelectionForeground());
            } else {
                this.component.setForeground(this.selectedForegroundColor);
            }
            if (hasFocus) {
                if (table.isCellEditable(row, column)) {
                    this.component.setBorder(this._focusedCellBorder);
                    this.component.setForeground(UIManager.getColor("Table.focusCellForeground"));
                    this.component.setBackground(UIManager.getColor("Table.focusCellBackground"));
                }
            } else {
                this.component.setBorder(noFocusBorder);
            }
        }
        return this.component;
    }

    protected Component renderCellComponent(JTable table, Object value, boolean hasFocus, int row, int column) {
        if (table instanceof RmaJTable) {
            RmaJTable rmatable = (RmaJTable)table;
            if (rmatable.getAlternatingReportBackground()) {
                if (row % 2 == 0) {
                    if (rmatable.getAlternatingReportBackgroundColor() != null) {
                        this.component.setBackground(rmatable.getAlternatingReportBackgroundColor());
                    } else {
                        this.component.setBackground(this._alternateRowBackground);
                    }
                } else {
                    this.component.setBackground(rmatable.getBackground());
                }
            } else {
                this.component.setBackground(rmatable.getCellBackground(row, column));
            }
            this.component.setForeground(rmatable.getCellForeground(row, column));
            RmaJTable rmaTable = (RmaJTable)table;
            Font f = rmaTable.getCellFont(row, column);
            if (f != null) {
                this.component.setFont(f);
            }
            if (rmatable.getRowHeaderEnabled() && column == 0) {
                if (table.isEnabled() && table.isCellEditable(row, column)) {
                    this.component.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                }
                if (((RmaJTable)table).getAutoRowHeaders()) {
                    this.value.setValue(Integer.toString(row + rmatable.getAutoRowHeaderOffset()));
                    if (this.component instanceof JLabel) {
                        ((JLabel)this.component).setHorizontalAlignment(0);
                    }
                } else {
                    this.value.setValue(value);
                    if (this.component instanceof JLabel) {
                        ((JLabel)this.component).setHorizontalAlignment(2);
                    }
                }
                return this.component;
            }
            if (hasFocus) {
                if (table.isCellEditable(row, column)) {
                    this.component.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                    this.component.setBackground(UIManager.getColor("Table.focusCellBackground"));
                } else {
                    this.component.setBorder(noFocusBorder);
                }
            } else {
                this.component.setBorder(noFocusBorder);
            }
            if (rmatable.isEditable() && !table.isCellEditable(row, column) && !rmatable.getAlternatingReportBackground()) {
                if (rmatable.getAlternatingReportBackgroundColor() != null) {
                    this.component.setBackground(rmatable.getAlternatingReportBackgroundColor());
                } else {
                    this.component.setBackground(UIManager.getColor("TextField.disabledBackground"));
                }
            }
        } else {
            this.component.setBackground(this.backgroundColor);
            this.component.setForeground(this.foregroundColor);
            if (hasFocus) {
                if (table.isCellEditable(row, column)) {
                    this.component.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                    this.component.setForeground(UIManager.getColor("Table.focusCellForeground"));
                    this.component.setBackground(UIManager.getColor("Table.focusCellBackground"));
                } else {
                    this.component.setBorder(noFocusBorder);
                }
            } else {
                this.component.setBorder(noFocusBorder);
            }
        }
        return this.component;
    }

    @Override
    public void setDisplayUnitsSystem(int unitsSystem) {
        this._unitSystem = unitsSystem;
    }

    @Override
    public void setDisplayScaleFactor(int paramId, double scaleFactor) {
        this._paramIdForScaling = paramId;
        this._scaleFactor = scaleFactor;
    }

    public void setDisplayScaleFactor(int col, int paramId, double scaleFactor) {
        this._columnScalingList.put(new Integer(col), new ParameterScale(scaleFactor, paramId));
    }

    public void setMissingString(String missingStr) {
        if (missingStr == null) {
            missingStr = "";
        }
        this._missingString = missingStr;
    }

    public void setShowCommas(boolean showCommas) {
        this._showComma = showCommas;
    }

    static {
        DEBUG = Boolean.getBoolean("RmaCellRenderer.debug");
    }

    protected class ValueProperty
    implements Serializable {
        protected Object value;

        protected ValueProperty() {
        }

        public void setValue(Object x) {
            this.value = x;
        }
    }

    private class ParameterScale
    implements IParameterScale {
        double scale = 1.0;
        int paramId = -1;

        public ParameterScale(double scl, int param) {
            this.scale = scl;
            this.paramId = param;
        }

        @Override
        public int getParamId() {
            return this.paramId;
        }

        @Override
        public double getScale() {
            return this.scale;
        }
    }
}

