/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;
import rma.swing.ColorIcon;

public class RmaColorRenderer
extends JLabel
implements ListCellRenderer,
TableCellRenderer {
    private ColorIcon icon = new ColorIcon(Color.GRAY, 50, 13);
    private boolean renderColorName = true;

    public RmaColorRenderer() {
        this.setOpaque(true);
        this.setIcon(this.icon);
    }

    public void setRenderColorName(boolean b) {
        this.renderColorName = b;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            this.icon.setColor((Color)array[0]);
            if (this.renderColorName) {
                this.setText((String)array[1]);
            } else {
                this.setText("");
            }
        } else {
            this.setText("");
            this.icon.setColor(list.getBackground());
        }
        if (isSelected) {
            this.setForeground(list.getSelectionForeground());
            this.setBackground(list.getSelectionBackground());
        } else {
            this.setForeground(list.getForeground());
            this.setBackground(list.getBackground());
        }
        return this;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            this.icon.setColor((Color)array[0]);
            if (this.renderColorName) {
                this.setText((String)array[1]);
            } else {
                this.setText("");
            }
        } else if (value instanceof Color) {
            this.icon.setColor((Color)value);
            this.setText("");
        } else {
            this.icon.setColor(table.getBackground());
            this.setText("");
        }
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
        }
        return this;
    }
}

