/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import hec.heclib.util.HecTime;
import hec.heclib.util.HecTimeArray;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.TimeZone;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import rma.swing.RmaJ24HourTimeField;
import rma.swing.RmaJCalendarField;

public class RmaDateTimeEditor
extends AbstractCellEditor
implements TableCellEditor {
    public static final int EDIT_DATE = 0;
    public static final int EDIT_TIME = 1;
    protected EditorDelegate delegate;
    private TimeZone m_displayTimeZone = TimeZone.getDefault();
    private int m_editType = 0;
    private SimpleDateFormat m_dateFormat = null;
    private SimpleDateFormat m_timeFormat = null;
    private int m_clickCountToStart = 2;
    Component m_editComponent = null;
    private boolean m_ignoreTimeZoneAdjust = false;

    public RmaDateTimeEditor(RmaJCalendarField dateField) {
        this.m_editType = 0;
        this.m_editComponent = dateField;
        this.m_dateFormat = new SimpleDateFormat(dateField.getFormat());
        this.m_timeFormat = new SimpleDateFormat("HHmm");
        this.delegate = new EditorDelegate(){
            String strDate;
            String strTime;
            TimeZone dataTimeZone;
            {
                this.strDate = "";
                this.strTime = "";
                this.dataTimeZone = null;
            }

            @Override
            public void setValue(Object obj) {
                this.value = obj;
                if (obj instanceof HecTimeArray) {
                    HecTimeArray hTimeArray = (HecTimeArray)obj;
                    this.dataTimeZone = hTimeArray.getTimeZone();
                    if (hTimeArray.numberElements() == 0) {
                        ((RmaJCalendarField)RmaDateTimeEditor.this.m_editComponent).setText("");
                        this.value = null;
                        return;
                    }
                    Date date = hTimeArray.element(0).getJavaDate(this.dataTimeZone.getRawOffset() / 60000);
                    if (RmaDateTimeEditor.this.m_ignoreTimeZoneAdjust) {
                        RmaDateTimeEditor.this.setTimeZone(this.dataTimeZone);
                    }
                    this.strDate = RmaDateTimeEditor.this.m_dateFormat.format(date);
                    this.strTime = RmaDateTimeEditor.this.m_timeFormat.format(date);
                    ((RmaJCalendarField)RmaDateTimeEditor.this.m_editComponent).setText(this.strDate);
                } else {
                    ((RmaJCalendarField)RmaDateTimeEditor.this.m_editComponent).setText("");
                    this.value = null;
                }
            }

            @Override
            public Object getCellEditorValue() {
                String tempDate = ((RmaJCalendarField)RmaDateTimeEditor.this.m_editComponent).getText();
                SimpleDateFormat sdf = new SimpleDateFormat(RmaDateTimeEditor.this.m_dateFormat.toPattern() + " " + RmaDateTimeEditor.this.m_timeFormat.toPattern());
                Date jDate = null;
                if (this.strTime.equals("")) {
                    this.strTime = "0000";
                }
                try {
                    TimeZone tz;
                    TimeZone timeZone = tz = RmaDateTimeEditor.this.m_ignoreTimeZoneAdjust ? this.dataTimeZone : RmaDateTimeEditor.this.m_displayTimeZone;
                    if (tz != null) {
                        sdf.setTimeZone(tz);
                    }
                    jDate = sdf.parse(tempDate + " " + this.strTime);
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
                if (jDate == null) {
                    System.out.println("ERROR with Date/Time Parse");
                    return null;
                }
                HecTime hTime = new HecTime(jDate, this.dataTimeZone.getRawOffset() / 60000);
                HecTimeArray hTimeArray = null;
                hTimeArray = this.value == null ? new HecTimeArray(1) : (HecTimeArray)this.value;
                hTimeArray.setElementAt(hTime, 0);
                hTimeArray.setTimeZone(this.dataTimeZone);
                return hTimeArray;
            }
        };
    }

    public RmaDateTimeEditor(RmaJ24HourTimeField timeField) {
        this.m_editType = 1;
        this.m_editComponent = timeField;
        this.m_dateFormat = new SimpleDateFormat("ddMMMyyyy");
        this.m_timeFormat = new SimpleDateFormat("HHmm");
        this.delegate = new EditorDelegate(){
            String strDate = "";
            String strTime = "";
            TimeZone dataTimeZone;

            @Override
            public void setValue(Object obj) {
                if (obj instanceof HecTimeArray) {
                    this.value = obj;
                    HecTimeArray hTimeArray = (HecTimeArray)obj;
                    this.dataTimeZone = hTimeArray.getTimeZone();
                    if (hTimeArray.numberElements() == 0) {
                        ((RmaJ24HourTimeField)RmaDateTimeEditor.this.m_editComponent).setText("");
                        this.value = null;
                        return;
                    }
                    Date date = hTimeArray.element(0).getJavaDate(this.dataTimeZone.getRawOffset() / 60000);
                    if (RmaDateTimeEditor.this.m_ignoreTimeZoneAdjust) {
                        RmaDateTimeEditor.this.setTimeZone(this.dataTimeZone);
                    }
                    this.strDate = RmaDateTimeEditor.this.m_dateFormat.format(date);
                    this.strTime = RmaDateTimeEditor.this.m_timeFormat.format(date);
                    ((RmaJ24HourTimeField)RmaDateTimeEditor.this.m_editComponent).setText(this.strTime);
                } else {
                    ((RmaJ24HourTimeField)RmaDateTimeEditor.this.m_editComponent).setText("");
                    this.value = null;
                }
            }

            @Override
            public Object getCellEditorValue() {
                String tempTime = ((RmaJ24HourTimeField)RmaDateTimeEditor.this.m_editComponent).getText();
                SimpleDateFormat sdf = new SimpleDateFormat(RmaDateTimeEditor.this.m_dateFormat.toPattern() + " " + RmaDateTimeEditor.this.m_timeFormat.toPattern());
                Date jDate = null;
                if (this.strDate.equals("")) {
                    this.strDate = "01Jan";
                }
                try {
                    sdf.setTimeZone(RmaDateTimeEditor.this.m_displayTimeZone);
                    jDate = sdf.parse(this.strDate + " " + tempTime);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (jDate == null) {
                    System.out.println("ERROR with Date/Time Parse");
                    return null;
                }
                HecTime hTime = new HecTime(jDate, this.dataTimeZone.getRawOffset() / 60000);
                HecTimeArray hTimeArray = null;
                hTimeArray = this.value == null ? new HecTimeArray(1) : (HecTimeArray)this.value;
                hTimeArray.setElementAt(hTime, 0);
                hTimeArray.setTimeZone(this.dataTimeZone);
                return hTimeArray;
            }
        };
    }

    public void setIgnoreTimeZoneAdjustments(boolean ignore) {
        this.m_ignoreTimeZoneAdjust = ignore;
    }

    @Override
    public Object getCellEditorValue() {
        return this.delegate.getCellEditorValue();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.delegate.setValue(value);
        return this.m_editComponent;
    }

    @Override
    protected void fireEditingCanceled() {
        super.fireEditingCanceled();
    }

    @Override
    protected void fireEditingStopped() {
        super.fireEditingStopped();
    }

    public void setTimeZone(TimeZone tz) {
        TimeZone tempTz;
        this.m_displayTimeZone = tempTz = (TimeZone)tz.clone();
        this.m_dateFormat.setTimeZone(tempTz);
        this.m_timeFormat.setTimeZone(tempTz);
    }

    public void setClickCountToStart(int ccts) {
        this.m_clickCountToStart = ccts;
    }

    public int getClickCountToStart() {
        return this.m_clickCountToStart;
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        return this.delegate.isCellEditable(event);
    }

    protected class EditorDelegate
    implements ActionListener,
    ItemListener,
    Serializable {
        protected Object value;

        protected EditorDelegate() {
        }

        public Object getCellEditorValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                return ((MouseEvent)anEvent).getClickCount() >= RmaDateTimeEditor.this.m_clickCountToStart;
            }
            return true;
        }

        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        public boolean startCellEditing(EventObject anEvent) {
            return true;
        }

        public boolean stopCellEditing() {
            RmaDateTimeEditor.this.fireEditingStopped();
            return true;
        }

        public void cancelCellEditing() {
            RmaDateTimeEditor.this.fireEditingCanceled();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.stopCellEditing();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.stopCellEditing();
        }
    }
}

