/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import hec.heclib.util.HecTime;
import hec.heclib.util.HecTimeArray;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import rma.swing.table.RmaCellRenderer;

public class RmaDateTimeRenderer
extends RmaCellRenderer
implements TableCellRenderer {
    public static final int DATE_RENDERER = 0;
    public static final int TIME_RENDERER = 1;
    public static final int DATE_AND_TIME_RENDERER = 2;
    static Border noFocusBorder = new EmptyBorder(1, 2, 1, 2);
    private SimpleDateFormat m_dateFormat = null;
    private SimpleDateFormat m_timeFormat = null;
    private SimpleDateFormat m_dateTimeFormat = null;
    private int m_renderType = 0;
    private TimeZone m_displayTimeZone = TimeZone.getDefault();
    private boolean m_ignoreTimeZoneAdjust = false;
    private boolean _useDataDefinedViewTimeZone = false;
    private HecTime m_tmpTime;

    public RmaDateTimeRenderer(int type) {
        super(new JLabel());
        if (type != 0 && type != 1 && type != 2) {
            throw new IllegalArgumentException("ERROR <RmaDateTimeRenderer.RmaDateTimeRenderer()> : Illegal Renderer Type" + type);
        }
        this.m_renderType = type;
        if (this.m_renderType == 0) {
            this.m_dateFormat = new SimpleDateFormat("ddMMMyyyy");
            this.m_dateFormat.setTimeZone(this.m_displayTimeZone);
        } else if (this.m_renderType == 1) {
            this.m_timeFormat = new SimpleDateFormat("HHmm");
            this.m_timeFormat.setTimeZone(this.m_displayTimeZone);
        } else {
            this.m_dateTimeFormat = new SimpleDateFormat("ddMMMyyyy HHmm");
            this.m_dateTimeFormat.setTimeZone(this.m_displayTimeZone);
            this.m_tmpTime = new HecTime();
        }
    }

    public RmaDateTimeRenderer(int type, String format) {
        super(new JLabel());
        if (type != 0 && type != 1 && type != 2) {
            throw new IllegalArgumentException("ERROR <RmaDateTimeRenderer.RmaDateTimeRenderer()> : Illegal Renderer Type" + type);
        }
        this.m_renderType = type;
        if (this.m_renderType == 0) {
            this.m_dateFormat = new SimpleDateFormat(format);
            this.m_dateFormat.setTimeZone(this.m_displayTimeZone);
        } else if (this.m_renderType == 0) {
            this.m_timeFormat = new SimpleDateFormat(format);
            this.m_timeFormat.setTimeZone(this.m_displayTimeZone);
        } else {
            this.m_dateTimeFormat = new SimpleDateFormat(format);
            this.m_dateTimeFormat.setTimeZone(this.m_displayTimeZone);
        }
    }

    public void setIgnoreTimeZoneAdjustments(boolean ignore) {
        this.m_ignoreTimeZoneAdjust = ignore;
    }

    public void setUseDataDefinedViewTimeZone(boolean tf) {
        this._useDataDefinedViewTimeZone = tf;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
        if (value == null) {
            return label;
        }
        Date date = null;
        TimeZone dataTimeZone = null;
        TimeZone viewTimeZone = null;
        boolean showAsEndOfDay = false;
        if (value instanceof HecTimeArray) {
            HecTimeArray timeArray = (HecTimeArray)value;
            if (timeArray.numberElements() == 0) {
                label.setText("");
                return label;
            }
            HecTime hTime = null;
            viewTimeZone = timeArray.getViewTimeZone();
            hTime = viewTimeZone == null ? timeArray.element(0) : timeArray.getTzUnconverted(0);
            showAsEndOfDay = hTime.getShowsTimeAsBeginningOfDay();
            dataTimeZone = timeArray.getTimeZone();
            if (dataTimeZone == null) {
                dataTimeZone = TimeZone.getTimeZone("UTC");
            }
            Instant instant = hTime.getInstant(dataTimeZone.toZoneId());
            date = Date.from(instant);
        } else if (value instanceof HecTime) {
            HecTime hTime = (HecTime)value;
            showAsEndOfDay = hTime.getShowsTimeAsBeginningOfDay();
            int minutesTimezoneOffset = 0;
            date = hTime.getJavaDate(minutesTimezoneOffset);
        } else if (value instanceof Date) {
            date = (Date)value;
        } else if (value instanceof Instant) {
            date = Date.from((Instant)value);
        }
        if (date == null) {
            label.setText(value.toString());
        } else {
            Object text;
            if (this.m_ignoreTimeZoneAdjust) {
                if (dataTimeZone == null) {
                    dataTimeZone = new SimpleTimeZone(0, "");
                }
                this.setTimeZone(dataTimeZone);
            } else if (this._useDataDefinedViewTimeZone && viewTimeZone != null) {
                this.setTimeZone(viewTimeZone);
            }
            if (this.m_renderType == 0) {
                label.setText(this.m_dateFormat.format(date));
            } else if (this.m_renderType == 1) {
                text = this.m_timeFormat.format(date);
                if (showAsEndOfDay && "00".equals(((String)text).substring(0, 2))) {
                    text = "24" + ((String)text).substring(2);
                }
                label.setText((String)text);
            } else {
                text = this.m_dateTimeFormat.format(date);
                if (this.m_tmpTime != null) {
                    this.m_tmpTime.set((String)text);
                    this.m_tmpTime.showTimeAsBeginningOfDay(showAsEndOfDay);
                    label.setText(this.m_tmpTime.dateAndTime(4));
                } else {
                    label.setText((String)text);
                }
            }
        }
        return label;
    }

    public void setTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            System.out.println("WARNING <RmaDateTimeRenderer.setTimeZone()> : NULL Time Zone value being set");
            return;
        }
        this.m_displayTimeZone = (TimeZone)timeZone.clone();
        if (this.m_renderType == 0) {
            this.m_dateFormat.setTimeZone(this.m_displayTimeZone);
        } else if (this.m_renderType == 1) {
            this.m_timeFormat.setTimeZone(this.m_displayTimeZone);
        } else {
            this.m_dateTimeFormat.setTimeZone(this.m_displayTimeZone);
        }
    }
}

