/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;
import rma.swing.RmaImage;
import rma.swing.TextColorIcon;

public class RmaImageRenderer
extends JLabel
implements ListCellRenderer,
TableCellRenderer {
    private Icon icon = new ImageIcon();

    public RmaImageRenderer() {
        this.setOpaque(true);
        this.setIcon(this.icon);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (isSelected) {
            this.setForeground(list.getSelectionForeground());
            this.setBackground(list.getSelectionBackground());
        } else {
            this.setForeground(list.getForeground());
            this.setBackground(list.getBackground());
        }
        if (value instanceof TextColorIcon) {
            TextColorIcon tci = (TextColorIcon)value;
            this.icon = RmaImage.getImageIcon(tci.getImageUrl());
            this.setIcon(this.icon);
            if (tci.getText() != null) {
                this.setText(tci.getText());
            } else {
                this.setText("");
            }
            this.setForeground(tci.getTextColor());
        } else if (value == null) {
            this.setIcon(null);
            this.setText("");
            this.setForeground(Color.black);
        } else if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            this.icon = RmaImage.getImageIcon(array[0].toString());
            this.setOpaque(true);
            this.setIcon(this.icon);
            if (array[1] != null) {
                this.setText(array[1].toString());
            } else {
                this.setText("");
            }
            if (array[2].toString().toLowerCase().equals("red")) {
                this.setForeground(Color.red);
            } else {
                this.setForeground(Color.black);
            }
        }
        return this;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
        }
        if (value instanceof TextColorIcon) {
            TextColorIcon tci = (TextColorIcon)value;
            this.icon = RmaImage.getImageIcon(tci.getImageUrl());
            this.setIcon(this.icon);
            if (tci.getText() != null) {
                this.setText(tci.getText());
            } else {
                this.setText("");
            }
            this.setForeground(tci.getTextColor());
        } else if (value == null) {
            this.setIcon(null);
            this.setText("");
            this.setForeground(Color.black);
        } else if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            this.icon = RmaImage.getImageIcon(array[0].toString());
            this.setIcon(this.icon);
            if (array[1] != null) {
                this.setText(array[1].toString());
            } else {
                this.setText("");
            }
            if (array[2].toString().toLowerCase().equals("red")) {
                this.setForeground(Color.red);
            } else {
                this.setForeground(Color.black);
            }
        }
        return this;
    }
}

