/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.prefs.Preferences;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.IExportOptions;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.swing.table.TableExportOptions;

public class RmaJTableExportDialog
extends RmaJDialog
implements IExportOptions {
    private boolean _canceled;
    private RmaJComboBox _delimiterCombo;
    private RmaJCheckBox _fixedWidthColumnsCB;
    private RmaJCheckBox _quotedStringsCB;
    private RmaJCheckBox _columnHeadersCB;
    private RmaJCheckBox _rowHeadersCB;
    private RmaJCheckBox _gridLinesCB;
    private RmaJCheckBox _titleCB;
    private RmaJTextField _titleField;
    private ButtonCmdPanel _cmdPanel;
    private RmaJTable _table;

    public RmaJTableExportDialog(Frame frame) {
        super(frame, true);
        this.buildControls();
        if (frame != null) {
            this._titleField.setText(frame.getTitle());
        }
    }

    public RmaJTableExportDialog(Dialog dialog) {
        super(dialog, true);
        this.buildControls();
        if (dialog != null) {
            this._titleField.setText(dialog.getTitle());
        }
        this.doPreferences(false);
    }

    public void setRowHeadersEndabled(boolean b) {
        this._rowHeadersCB.setEnabled(b);
    }

    public static RmaJTableExportDialog getExportDialog(RmaJTable table) {
        Window w = SwingUtilities.windowForComponent(table);
        RmaJTableExportDialog dialog = w instanceof Dialog ? new RmaJTableExportDialog((Dialog)w) : new RmaJTableExportDialog((Frame)w);
        dialog._table = table;
        dialog._rowHeadersCB.setEnabled(dialog._table.getRowHeaderEnabled());
        return dialog;
    }

    protected void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Table Export Options");
        JLabel label = new JLabel("Field Delimiter:", 4);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(7, 5, 0, 5);
        this.getContentPane().add((Component)label, gbc);
        this._delimiterCombo = new RmaJComboBox<String>(DELIMITERS);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this._delimiterCombo, gbc);
        this._fixedWidthColumnsCB = new RmaJCheckBox("Fixed Width Columns");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this._fixedWidthColumnsCB, gbc);
        this._quotedStringsCB = new RmaJCheckBox("Quoted Strings");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this._quotedStringsCB, gbc);
        this._columnHeadersCB = new RmaJCheckBox("Include Column Headers", true);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this._columnHeadersCB, gbc);
        this._rowHeadersCB = new RmaJCheckBox("Include Row Headers");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this._rowHeadersCB, gbc);
        this._gridLinesCB = new RmaJCheckBox("Print GridLines");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this._gridLinesCB, gbc);
        JPanel panel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(0, 0, 0, 0);
        this.getContentPane().add((Component)panel, gbc);
        this._titleCB = new RmaJCheckBox("Print Title:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        panel.add((Component)this._titleCB, gbc);
        this._titleField = new RmaJTextField(17);
        this._titleField.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 6;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        panel.add((Component)this._titleField, gbc);
        this._cmdPanel = new ButtonCmdPanel(12);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this._cmdPanel, gbc);
        this._cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            @Override
            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        RmaJTableExportDialog.this._canceled = false;
                        RmaJTableExportDialog.this.doPreferences(true);
                        RmaJTableExportDialog.this.setVisible(false);
                        break;
                    }
                    case 4: {
                        RmaJTableExportDialog.this._canceled = true;
                        RmaJTableExportDialog.this.setVisible(false);
                    }
                }
            }
        });
        this._titleCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RmaJTableExportDialog.this._titleField.setEnabled(RmaJTableExportDialog.this._titleCB.isSelected());
            }
        });
        this._gridLinesCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = RmaJTableExportDialog.this._gridLinesCB.isSelected();
                RmaJTableExportDialog.this._delimiterCombo.setEnabled(!selected);
                RmaJTableExportDialog.this._fixedWidthColumnsCB.setEnabled(!selected);
                if (selected) {
                    RmaJTableExportDialog.this._fixedWidthColumnsCB.setSelected(true);
                }
            }
        });
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
        this.pack();
        this.setSize(this.getPreferredSize());
        this.setResizable(false);
        this.setLocationRelativeTo(this._table);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RmaJTableExportDialog.this._canceled = true;
            }
        });
        this.doPreferences(false);
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public TableExportOptions getExportOptions() {
        TableExportOptions teo = new TableExportOptions();
        teo.delimiter = DELIMITER_CHARS[this._delimiterCombo.getSelectedIndex()];
        teo.fixedWidthCols = this._fixedWidthColumnsCB.isSelected();
        teo.quotedStrings = this._quotedStringsCB.isSelected();
        teo.columnHeader = this._columnHeadersCB.isSelected();
        teo.rowHeader = this._rowHeadersCB.isSelected();
        teo.gridLines = this._gridLinesCB.isSelected();
        if (this._titleCB.isSelected()) {
            teo.title = this._titleField.getText();
        }
        return teo;
    }

    protected void doPreferences(boolean set) {
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        if (set) {
            preferences.putInt("Delimiter", this._delimiterCombo.getSelectedIndex());
            preferences.putBoolean("FixedWidthColumns", this._fixedWidthColumnsCB.isSelected());
            preferences.putBoolean("QuotedStrings", this._quotedStringsCB.isSelected());
            preferences.putBoolean("ColumnHeaders", this._columnHeadersCB.isSelected());
            preferences.putBoolean("RowHeaders", this._rowHeadersCB.isSelected());
            preferences.putBoolean("PrintGridLines", this._gridLinesCB.isSelected());
            preferences.putBoolean("PrintTitle", this._titleCB.isSelected());
        } else {
            this._delimiterCombo.setSelectedIndex(preferences.getInt("Delimiter", 0));
            this._fixedWidthColumnsCB.setSelected(preferences.getBoolean("FixedWidthColumns", false));
            this._quotedStringsCB.setSelected(preferences.getBoolean("QuotedStrings", false));
            this._columnHeadersCB.setSelected(preferences.getBoolean("ColumnHeaders", false));
            this._rowHeadersCB.setSelected(preferences.getBoolean("RowHeaders", false));
            this._gridLinesCB.setSelected(preferences.getBoolean("PrintGridLines", false));
            this._titleCB.setSelected(preferences.getBoolean("PrintTitle", false));
        }
    }

    public void setExportOptions(TableExportOptions teo) {
        for (int i = 0; i < DELIMITER_CHARS.length; ++i) {
            if (teo.delimiter != DELIMITER_CHARS[i]) continue;
            this._delimiterCombo.setSelectedIndex(i);
            break;
        }
        this._fixedWidthColumnsCB.setSelected(teo.fixedWidthCols);
        this._quotedStringsCB.setSelected(teo.quotedStrings);
        this._columnHeadersCB.setSelected(teo.columnHeader);
        this._rowHeadersCB.setSelected(teo.rowHeader);
        this._gridLinesCB.setSelected(teo.gridLines);
        boolean selected = teo.gridLines;
        this._delimiterCombo.setEnabled(!selected);
        this._fixedWidthColumnsCB.setEnabled(!selected);
        if (selected) {
            this._fixedWidthColumnsCB.setSelected(true);
        }
        if (teo.title == null) {
            this._titleCB.setSelected(false);
            this._titleField.setEnabled(false);
            this._titleField.setText("");
        } else {
            this._titleField.setText(teo.title);
            this._titleField.setEnabled(true);
            this._titleCB.setSelected(true);
        }
    }
}

