/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import rma.swing.ButtonCmdPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTable;

public class RmaJTableFillDialog
extends RmaJDialog {
    private final RmaJRadioButton _linearFillCB = new RmaJRadioButton("Linear Fill", true);
    private final RmaJRadioButton _repeatFillCB = new RmaJRadioButton("Repeat Fill");
    private final RmaJRadioButton _fillToEndCB = new RmaJRadioButton("Repeat to End");
    private final RmaJRadioButton _constantFillCB = new RmaJRadioButton("Add Constant:");
    private final RmaJRadioButton _factorFillCB = new RmaJRadioButton("Multiple Factor:");
    private final RmaJDecimalField _constantTxt = new RmaJDecimalField();
    private final RmaJDecimalField _factorTxt = new RmaJDecimalField();
    private final ButtonGroup _buttonGroup = new ButtonGroup();
    private final RmaJTable _table;
    private boolean _canceled;

    protected RmaJTableFillDialog(Frame frame, RmaJTable table) {
        super(frame, true);
        this._table = table;
        this.initComponents();
    }

    protected RmaJTableFillDialog(Dialog dialog, RmaJTable table) {
        super(dialog, true);
        this._table = table;
        this.initComponents();
    }

    private void initComponents() {
        this.setTitle("Table Fill Options");
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        ButtonCmdPanel cmdPanel = new ButtonCmdPanel(12);
        cmdPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        cmdPanel.addCmdPanelListener(this::commandPanelActionPerformed);
        this.getContentPane().add((Component)cmdPanel, "South");
        JPanel panel = this.buildControls();
        this.getContentPane().add((Component)panel, "Center");
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
        this.pack();
        this.setSize(this.getPreferredSize());
        this.setLocationRelativeTo(this._table);
        this.setResizable(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void commandPanelActionPerformed(ActionEvent e) {
        int id = e.getID();
        if (id == 8) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                if (!this.fillTable()) return;
                this._canceled = false;
                this.setVisible(false);
                return;
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        } else {
            if (id != 4) return;
            this._canceled = true;
            this.setVisible(false);
        }
    }

    public static RmaJTableFillDialog getFillDialog(RmaJTable table) {
        Window w = SwingUtilities.windowForComponent(table);
        RmaJTableFillDialog dialog = w instanceof Dialog ? new RmaJTableFillDialog((Dialog)w, table) : new RmaJTableFillDialog((Frame)w, table);
        return dialog;
    }

    protected JPanel buildControls() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        panel.add((Component)this._linearFillCB, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        panel.add((Component)this._repeatFillCB, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        panel.add((Component)this._fillToEndCB, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        panel.add((Component)this._constantFillCB, gbc);
        this._constantTxt.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        panel.add((Component)this._constantTxt, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        panel.add((Component)this._factorFillCB, gbc);
        this._factorTxt.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        panel.add((Component)this._factorTxt, gbc);
        this._constantFillCB.addItemListener(ie -> this._constantTxt.setEnabled(ie.getStateChange() == 1));
        this._factorFillCB.addItemListener(ie -> this._factorTxt.setEnabled(ie.getStateChange() == 1));
        this._buttonGroup.add(this._linearFillCB);
        this._buttonGroup.add(this._repeatFillCB);
        this._buttonGroup.add(this._fillToEndCB);
        this._buttonGroup.add(this._constantFillCB);
        this._buttonGroup.add(this._factorFillCB);
        return panel;
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    protected boolean fillTable() {
        if (this._linearFillCB.isSelected()) {
            this._table.linearFill();
        } else if (this._repeatFillCB.isSelected()) {
            this._table.repeatFill();
        } else if (this._fillToEndCB.isSelected()) {
            this._table.fillToEnd();
        } else if (this._constantFillCB.isSelected()) {
            if (this._constantTxt.getText().isEmpty()) {
                JOptionPane.showMessageDialog(this, "Please enter a constant to add to the selected cells.", "No Constant Entered", 0);
                this._constantTxt.requestFocus();
                return false;
            }
            this._table.constantFill(this._constantTxt.getValue());
        } else if (this._factorFillCB.isSelected()) {
            if (this._factorTxt.getText().isEmpty()) {
                JOptionPane.showMessageDialog(this, "Please enter a Factor to multiple the selected cells by.", "No Factor Entered", 0);
                this._factorTxt.requestFocus();
                return false;
            }
            this._table.factorFill(this._factorTxt.getValue());
        }
        return true;
    }

    protected final ButtonGroup getButtonGroup() {
        return this._buttonGroup;
    }
}

