/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import com.google.common.flogger.StackSize;
import hec.data.ParamDouble;
import hec.data.ParamInteger;
import hec.data.Units;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.event.TableModelEvent;
import rma.swing.table.AbstractRmaTableModel;
import rma.swing.table.RmaTableModelInterface;
import rma.util.logging.MarkingClassLogger;
import rma.util.logging.marking.UnitsLoggingMarker;

public class RmaTableModel
extends AbstractRmaTableModel
implements RmaTableModelInterface {
    private static final MarkingClassLogger UNITS_LOGGER = MarkingClassLogger.forMarkingClass(UnitsLoggingMarker.class);
    public static final int UNDEF_COLUMN_UNIT_SYSTEM = -1;
    String filename;
    protected int[] colParamId = new int[0];
    String[] colNames = new String[0];
    String[] _templateColNames = new String[0];
    boolean[] editable = new boolean[0];
    Hashtable _clsTable = new Hashtable();
    protected Vector<Vector<Object>> rows = new Vector(0);
    Vector editableRows = new Vector();
    IntContainer chkRow = new IntContainer();
    Hashtable _nonEditableCells = new Hashtable();
    StringBuffer chkCell = new StringBuffer();

    public RmaTableModel() {
    }

    public RmaTableModel(String[] colNames) {
        this.colNames = colNames;
        this.rows = new Vector();
        this._templateColNames = colNames;
        this.colParamId = new int[colNames.length];
        this.editable = new boolean[colNames.length];
        this.m_unitSystem = 0;
        Arrays.fill(this.colParamId, -1);
    }

    public RmaTableModel(String[] colNames, Object[][] data, boolean[] editable) {
        this.colNames = colNames;
        this.editable = editable;
        this.filename = "";
        this.rows = new Vector(data.length);
        this._templateColNames = colNames;
        this.colParamId = new int[colNames.length];
        Arrays.fill(this.colParamId, -1);
        if (data != null) {
            for (int ii = 0; ii < data.length; ++ii) {
                Object[] dataRow = data[ii];
                for (int jj = 0; jj < dataRow.length; ++jj) {
                    if (jj >= this.getColumnCount()) continue;
                    Object obj = dataRow[jj];
                    if (obj == null) {
                        obj = " ";
                    }
                    this.setValueAt(obj, ii, jj);
                }
            }
        }
        this.m_unitSystem = 0;
    }

    public RmaTableModel(String[] colNames, int numRows, boolean[] editable, String filename) {
        this.colNames = colNames;
        this.editable = editable;
        this.filename = filename;
        this._templateColNames = colNames;
        this.rows = new Vector();
        for (int j = 0; j < numRows; ++j) {
            this.addRow();
        }
        this.colParamId = new int[colNames.length];
        Arrays.fill(this.colParamId, -1);
        this.m_unitSystem = 0;
    }

    public RmaTableModel(Vector columnNames, Vector rows, Vector editable) {
        this.rows = (Vector)rows.clone();
        this.colNames = new String[columnNames.size()];
        this._templateColNames = new String[columnNames.size()];
        columnNames.copyInto(this.colNames);
        columnNames.copyInto(this._templateColNames);
        if (editable.size() == 0) {
            this.editable = new boolean[columnNames.size()];
            for (int j = 0; j < this.editable.length; ++j) {
                this.editable[j] = true;
            }
        } else {
            this.editable = new boolean[editable.size()];
            for (int j = 0; j < editable.size(); ++j) {
                this.editable[j] = (Boolean)editable.elementAt(j);
            }
        }
        this.colParamId = new int[this.colNames.length];
        Arrays.fill(this.colParamId, -1);
        this.m_unitSystem = 0;
    }

    @Override
    public void setCellEnabled(boolean enabled, int row, int col) {
        if (row < 0 || col < 0) {
            return;
        }
        String s = this.getRowCellString(row, col);
        if (enabled) {
            this._nonEditableCells.remove(s);
        } else {
            this._nonEditableCells.put(s, s);
        }
    }

    public void clearNonEditableCells() {
        this._nonEditableCells.clear();
    }

    @Override
    public void setColEnabled(boolean enabled, int col) {
        if (this.editable == null) {
            return;
        }
        if (col > this.editable.length - 1) {
            return;
        }
        this.editable[col] = enabled;
    }

    @Override
    public void setRowEnabled(boolean enabled, int row) {
        if (row > this.getRowCount() - 1 || row < 0) {
            return;
        }
        IntContainer i = new IntContainer(row);
        if (!enabled && !this.editableRows.contains(i)) {
            this.editableRows.addElement(i);
        } else if (enabled) {
            this.editableRows.removeElement(i);
        }
    }

    @Override
    public void resetRowEnabled() {
        if (this.editableRows != null) {
            this.editableRows.removeAllElements();
        }
    }

    @Override
    public void addColumn(String colName) {
        this.addColumn(colName, null);
    }

    @Override
    public void addColumn(String columnName, Vector columnData) {
        if (columnName == null) {
            throw new IllegalArgumentException("addColumn() - null parameter");
        }
        if (columnData != null && this.rows.size() > 0 && columnData.size() != this.rows.size()) {
            throw new IllegalArgumentException("addColumn() - new column must have equal amount of rows as model");
        }
        int oldCapacity = this.colNames.length;
        String[] oldColNames = this._templateColNames;
        this._templateColNames = new String[oldCapacity + 1];
        System.arraycopy(oldColNames, 0, this._templateColNames, 0, oldCapacity);
        this._templateColNames[this._templateColNames.length - 1] = columnName;
        oldColNames = this.colNames;
        this.colNames = new String[oldCapacity + 1];
        System.arraycopy(oldColNames, 0, this.colNames, 0, oldCapacity);
        this.colNames[this.colNames.length - 1] = columnName;
        boolean[] oldEditable = this.editable;
        this.editable = new boolean[oldCapacity + 1];
        System.arraycopy(oldEditable, 0, this.editable, 0, oldCapacity);
        this.editable[this.editable.length - 1] = true;
        int[] oldColParamId = this.colParamId;
        this.colParamId = new int[oldCapacity + 1];
        System.arraycopy(oldColParamId, 0, this.colParamId, 0, oldCapacity);
        this.colParamId[this.colParamId.length - 1] = -1;
        if (this.rows.size() < 1 && columnData != null) {
            Enumeration enumeration = columnData.elements();
            while (enumeration.hasMoreElements()) {
                Vector newrow = new Vector();
                newrow.add(enumeration.nextElement());
                this.rows.add(newrow);
            }
        } else {
            int rowindex = 0;
            Enumeration<Vector<Object>> enumeration = this.rows.elements();
            while (enumeration.hasMoreElements()) {
                Object value = columnData != null ? (Object)columnData.elementAt(rowindex) : null;
                enumeration.nextElement().addElement(value);
                if (value instanceof ParamDouble) {
                    this.colParamId[this.colParamId.length - 1] = ((ParamDouble)value).getParameterId();
                    this.m_unitSystem = ((ParamDouble)value).getUnitSystem();
                } else if (value instanceof ParamInteger) {
                    this.colParamId[this.colParamId.length - 1] = ((ParamInteger)value).getParameterId();
                    this.m_unitSystem = ((ParamInteger)value).getUnitSystem();
                }
                ++rowindex;
            }
        }
        this.fireTableStructureChanged();
    }

    public void removeColumn(int colNum) {
        int i;
        int i2;
        if (colNum < 0) {
            throw new IllegalArgumentException("removeColumn() - column number can't be less than 0");
        }
        if (colNum >= this.colNames.length) {
            throw new IllegalArgumentException("removeColumn() - can't remove a column " + colNum + " past column size" + this.colNames.length);
        }
        int oldCapacity = this.colNames.length;
        int newCapacity = oldCapacity - 1;
        String[] oldColNames = this._templateColNames;
        this._templateColNames = new String[newCapacity];
        int idx = 0;
        for (i2 = 0; i2 < oldColNames.length; ++i2) {
            if (i2 == colNum) continue;
            this._templateColNames[idx] = oldColNames[i2];
            ++idx;
        }
        oldColNames = this.colNames;
        this.colNames = new String[newCapacity];
        idx = 0;
        for (i2 = 0; i2 < oldColNames.length; ++i2) {
            if (i2 == colNum) continue;
            this.colNames[idx] = oldColNames[i2];
            ++idx;
        }
        boolean[] oldEditable = this.editable;
        this.editable = new boolean[newCapacity];
        idx = 0;
        for (int i3 = 0; i3 < oldEditable.length; ++i3) {
            if (i3 == colNum) continue;
            this.editable[idx] = oldEditable[i3];
            ++idx;
        }
        int[] oldColParamId = this.colParamId;
        this.colParamId = new int[newCapacity];
        idx = 0;
        for (i = 0; i < oldColParamId.length; ++i) {
            if (i == colNum) continue;
            this.colParamId[idx] = oldColParamId[i];
            ++idx;
        }
        for (i = 0; i < this.rows.size(); ++i) {
            Vector<Object> rowData = this.rows.get(i);
            if (rowData.size() < colNum) continue;
            rowData.remove(colNum);
        }
        this.fireTableStructureChanged();
    }

    @Override
    public Vector getDataVector() {
        return this.rows;
    }

    @Override
    public void addRow(Vector newRow) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            newRow.addElement(new String());
        }
        this.rows.addElement(newRow);
        this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
    }

    @Override
    public void insertRow(int row, Vector rowData) {
        if (rowData == null) {
            rowData = new Vector(this.getColumnCount());
        } else {
            rowData.setSize(this.getColumnCount());
        }
        this.rows.insertElementAt(rowData, row);
        this.newRowsAdded(new TableModelEvent(this, row, row, -1, 1));
    }

    @Override
    public void insertRows(int startRow, int cnt, Vector rowData) {
        for (int row = 0; row < cnt; ++row) {
            this.rows.insertElementAt((Vector)rowData.clone(), startRow);
        }
        int endRow = cnt <= 0 ? startRow : startRow + cnt - 1;
        this.newRowsAdded(new TableModelEvent(this, startRow, endRow, -1, 1));
    }

    public void newRowsAdded(TableModelEvent event) {
        int start = event.getFirstRow();
        int end = event.getLastRow();
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = this.getRowCount() - 1;
        }
        for (int i = start; i <= end; ++i) {
            this.rows.elementAt(i).setSize(this.getColumnCount());
        }
        this.fireTableChanged(event);
    }

    @Override
    public int getColumnCount() {
        return this.colNames.length;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.getRowCount() || col >= this.getColumnCount()) {
            return null;
        }
        if (row < 0 || col < 0) {
            return null;
        }
        Vector<Object> rowVec = this.rows.elementAt(row);
        if (col >= rowVec.size()) {
            return null;
        }
        return rowVec.elementAt(col);
    }

    @Override
    public void setColumnNames(String[] colNames) {
        if (colNames != null) {
            int copySize = this.colNames.length > colNames.length ? colNames.length : this.colNames.length;
            this.colNames = colNames;
            this._templateColNames = colNames;
            int[] tmpColParamId = new int[colNames.length];
            Arrays.fill(tmpColParamId, -1);
            System.arraycopy(this.colParamId, 0, tmpColParamId, 0, copySize);
            this.colParamId = tmpColParamId;
            boolean[] tmpEditable = new boolean[colNames.length];
            System.arraycopy(this.editable, 0, tmpEditable, 0, copySize);
            this.editable = tmpEditable;
        }
    }

    @Override
    public void setColumnNames(Vector colNamesVector) {
        if (colNamesVector != null) {
            Object[] colNamesArray = new String[colNamesVector.size()];
            colNamesVector.copyInto(colNamesArray);
            this.setColumnNames((String[])colNamesArray);
        }
    }

    public void setColumnName(int col, String name) {
        if (col < 0 || col > this.colNames.length || name == null) {
            return;
        }
        this.colNames[col] = name;
    }

    @Override
    public String getColumnName(int col) {
        if (this.colNames == null) {
            return "";
        }
        if (col < this.colNames.length) {
            return this.colNames[col];
        }
        return "";
    }

    @Override
    public void setColumnClass(int col, Class cls) {
        this._clsTable.put(new Integer(col), cls);
    }

    @Override
    public Class getColumnClass(int col) {
        Class cls = (Class)this._clsTable.get(new Integer(col));
        if (cls != null) {
            return cls;
        }
        if (this.getValueAt(0, col) != null) {
            return this.getValueAt(0, col).getClass();
        }
        return new Object().getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (col < this.getColumnCount() && col > -1) {
            if (this.editable == null) {
                return true;
            }
            if (col < this.editable.length && !this.editable[col]) {
                return false;
            }
            this.chkRow.value = row;
            if (this.editableRows.contains(this.chkRow)) {
                return false;
            }
            String s = this.getRowCellString(row, col);
            if (this._nonEditableCells.get(s) != null) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void setValueAt(Object aValue, int row, int col) {
        Vector<Object> rowVec;
        Object value;
        try {
            Object pd;
            if (this.getColumnClass(col).getName().equals("hec.data.ParamDouble") && !(aValue instanceof ParamDouble)) {
                if (aValue == null) {
                    aValue = "";
                }
                pd = new ParamDouble();
                pd.setValue(aValue.toString());
                pd.setParameterId(this.getColumnParameter(col));
                pd.setUnitSystem(this.getUnitSystem());
                value = pd;
            } else if (this.getColumnClass(col).getName().equals("hec.data.ParamInteger") && !(aValue instanceof ParamInteger)) {
                if (aValue == null) {
                    aValue = "";
                }
                pd = new ParamInteger();
                ((ParamInteger)pd).setValue(aValue.toString());
                ((ParamInteger)pd).setParameterId(this.getColumnParameter(col));
                ((ParamInteger)pd).setUnitSystem(this.getUnitSystem());
                value = pd;
            } else {
                value = aValue;
            }
        }
        catch (Exception e) {
            value = aValue;
        }
        if (col >= this.colParamId.length) {
            int[] tempParamId = this.colParamId;
            this.colParamId = new int[col + 1];
            System.arraycopy(tempParamId, 0, this.colParamId, 0, tempParamId.length);
        }
        if (value instanceof ParamDouble) {
            if (this.colParamId.length > 0) {
                this.colParamId[col] = ((ParamDouble)value).getParameterId();
            }
            this.m_unitSystem = ((ParamDouble)value).getUnitSystem();
        } else if (value instanceof ParamInteger) {
            this.colParamId[col] = ((ParamInteger)value).getParameterId();
            this.m_unitSystem = ((ParamInteger)value).getUnitSystem();
        }
        while (row + 1 > this.getRowCount()) {
            this.addRow();
        }
        if (row < this.rows.size() && col < (rowVec = this.rows.get(row)).size()) {
            rowVec.setElementAt(value, col);
        }
        this.fireTableCellUpdated(row, col);
    }

    @Override
    public void clearAll() {
        int rowCnt = this.getRowCount();
        this.rows.removeAllElements();
        if (rowCnt > 0) {
            this.fireTableRowsDeleted(0, rowCnt - 1);
        }
    }

    @Override
    public void deleteRow(int index) {
        this.rows.removeElementAt(index);
        this.fireTableRowsDeleted(index, index);
    }

    protected void addRow() {
        Vector<String> newRow = new Vector<String>();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            newRow.addElement("");
        }
        this.rows.addElement(newRow);
        int index = this.rows.size() - 1;
        this.fireTableRowsInserted(index, index);
    }

    @Override
    public Vector getRow(int rowNum) {
        if (rowNum >= this.getRowCount() || rowNum < 0) {
            throw new ArrayIndexOutOfBoundsException("Row number " + rowNum + " out of range of 0-" + this.getRowCount());
        }
        return this.rows.elementAt(rowNum);
    }

    public void save() {
        try {
            FileOutputStream fos = new FileOutputStream(this.filename);
            GZIPOutputStream gzos = new GZIPOutputStream(fos);
            ObjectOutputStream out = new ObjectOutputStream(gzos);
            out.writeObject(this.colNames);
            out.writeObject(this.editable);
            out.writeObject(this.rows);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    public void load() {
        try {
            FileInputStream fis = new FileInputStream(this.filename);
            GZIPInputStream gzis = new GZIPInputStream(fis);
            ObjectInputStream in = new ObjectInputStream(gzis);
            this.colNames = (String[])in.readObject();
            this.editable = (boolean[])in.readObject();
            this.rows = (Vector)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public RmaTableModel getModel() {
        return this;
    }

    String getRowCellString(int row, int col) {
        this.chkCell.setLength(0);
        this.chkCell.append(row);
        this.chkCell.append(",");
        this.chkCell.append(col);
        return this.chkCell.toString();
    }

    @Override
    public int getColumnParameter(int col) {
        if (col < 0 || col >= this.colParamId.length) {
            return -1;
        }
        return this.colParamId[col];
    }

    @Override
    public void setColumnParameters(int[] params) {
        if (params == null) {
            return;
        }
        if (this.colParamId != null && params != null) {
            int copySize = this.colParamId.length > params.length ? params.length : this.colParamId.length;
            System.arraycopy(params, 0, this.colParamId, 0, copySize);
        } else {
            this.colParamId = params;
        }
    }

    public void setGmtOffset(int offset) {
        if (offset != Integer.MIN_VALUE && (offset < -11 || offset > 14)) {
            throw new IllegalArgumentException("ERROR <RmaTableModel.setGmtOffset()> : Invalid Offset " + offset + "! Offest must be either equal to undefinde (RMAConst.UNDEF_INT) or between the values of -11 and +14");
        }
        this.m_gmtOffset = offset;
    }

    @Override
    public int getGmtOffset() {
        return this.m_gmtOffset;
    }

    @Override
    public void setUnitSystem(int unitSystem) {
        if (!Units.isValidUnitsSystem(unitSystem)) {
            ((MarkingClassLogger.Api)((MarkingClassLogger.Api)UNITS_LOGGER.atFine()).withStackTrace(StackSize.FULL)).log("Invalid UnitSystem");
        }
        super.setUnitSystem(unitSystem);
    }

    protected class IntContainer {
        public int value;

        public IntContainer() {
            this.value = 0;
        }

        public IntContainer(int number) {
            this.value = number;
        }

        public String toString() {
            return Integer.toString(this.value);
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof IntContainer) {
                return this.value == ((IntContainer)obj).value;
            }
            return false;
        }

        public int hashCode() {
            return this.value;
        }
    }
}

