/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import rma.swing.RmaJTextField;

public class RowCellEditor
implements TableCellEditor,
Serializable {
    protected Hashtable editors = new Hashtable();
    protected TableCellEditor editor;
    protected TableCellEditor defaultEditor;
    protected int clickCountToStart = 1;

    public RowCellEditor() {
        this(new RmaJTextField());
    }

    public RowCellEditor(TableCellEditor tce) {
        this.defaultEditor = tce;
    }

    protected RowCellEditor(RmaJTextField field) {
        this(new DefaultCellEditor(field));
        field.setBorder(new LineBorder(Color.black));
    }

    public void add(int row, TableCellEditor editor) {
        this.editors.put(new Integer(row), editor);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        int modelRow = table.convertRowIndexToModel(row);
        this.editor = (TableCellEditor)this.editors.get(new Integer(modelRow));
        if (this.editor == null) {
            this.editor = this.defaultEditor;
        }
        return this.editor.getTableCellEditorComponent(table, value, isSelected, modelRow, column);
    }

    public void setClickCountToStart(int clickCount) {
        this.clickCountToStart = clickCount;
    }

    @Override
    public Object getCellEditorValue() {
        return this.editor.getCellEditorValue();
    }

    @Override
    public boolean stopCellEditing() {
        return this.editor.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        this.editor.cancelCellEditing();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (this.editor != null) {
            return this.editor.isCellEditable(anEvent);
        }
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= this.clickCountToStart;
        }
        return true;
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.editor.addCellEditorListener(l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.editor.removeCellEditorListener(l);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return this.editor.shouldSelectCell(anEvent);
    }

    public TableCellEditor getCellEditor(int row) {
        return (TableCellEditor)this.editors.get(new Integer(row));
    }

    public Map getCellEditorTable() {
        return this.editors;
    }
}

