/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import rma.swing.RmaInsets;

public class ShowAndPickColorPanel
extends JPanel {
    private final JColorChooser _chooser = new JColorChooser();
    private JButton _colorPickerButton;
    private String _hexPrefix = "#";

    public ShowAndPickColorPanel() {
        this.buildComponents();
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this._colorPickerButton != null) {
            this._colorPickerButton.setBackground(color);
        }
    }

    @Override
    public String getToolTipText() {
        int r = this.getBackground().getRed();
        int g = this.getBackground().getGreen();
        int b = this.getBackground().getBlue();
        return String.format(this._hexPrefix + "%02x%02x%02x", r, g, b);
    }

    public void setHexPrefix(String prefix) {
        this._hexPrefix = prefix;
    }

    public String getHexPrefix() {
        return this._hexPrefix;
    }

    private void buildComponents() {
        this.setLayout(new GridBagLayout());
        this._colorPickerButton = new JButton("...");
        this._colorPickerButton.setBorder(new EmptyBorder(-2, 6, -2, 5));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 12;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS0000;
        this.add((Component)this._colorPickerButton, gbc);
        this._colorPickerButton.addActionListener(e -> {
            ActionListener okListener = evt -> this.setBackground(this._chooser.getColor());
            ActionListener cancelListener = evt -> {};
            JDialog chooserDialog = JColorChooser.createDialog(this, "Choose a New Color", true, this._chooser, okListener, cancelListener);
            chooserDialog.setResizable(false);
            chooserDialog.setVisible(true);
        });
    }
}

