/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import javax.swing.RowFilter;
import rma.util.WildCardFileFilter;

public class SimpleRowFilter
extends RowFilter {
    private String _filter;
    private int _col;
    private boolean _hasWildCard;

    public SimpleRowFilter(String filter, int col) {
        this.setFilter(filter);
        this._col = col;
    }

    public void setFilter(String filter) {
        this._filter = filter.toLowerCase();
        this._hasWildCard = this._filter != null ? filter.indexOf("*") > -1 : false;
    }

    public boolean include(RowFilter.Entry entry) {
        if (this._col == -1) {
            for (int c2 = 0; c2 < entry.getValueCount(); ++c2) {
                String value = entry.getStringValue(c2);
                if (this._hasWildCard) {
                    if (!WildCardFileFilter.match(this._filter, value)) continue;
                    return true;
                }
                return value.toLowerCase().startsWith(this._filter);
            }
            return false;
        }
        String value = entry.getStringValue(this._col);
        if (this._hasWildCard) {
            return WildCardFileFilter.match(this._filter, value);
        }
        return value.toLowerCase().startsWith(this._filter);
    }
}

