/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TableColumnHider {
    private JTable _table;
    private TableColumnModel _tcm;
    private LinkedHashMap<String, IndexedColumn> _hidden = new LinkedHashMap();
    private boolean _reorder = true;

    public TableColumnHider(JTable table) {
        this._table = table;
        this._tcm = table.getColumnModel();
    }

    public TableColumnHider(JTable table, boolean reorder) {
        this._table = table;
        this._tcm = table.getColumnModel();
        this._reorder = reorder;
    }

    public void hide(int index) {
        if (index > -1) {
            TableColumn column = this._tcm.getColumn(index);
            IndexedColumn ic = new IndexedColumn(index, column);
            if (this._hidden.put(column.getHeaderValue().toString(), ic) != null) {
                throw new IllegalArgumentException("Duplicate column name.");
            }
            this._tcm.removeColumn(column);
        }
    }

    public void hide(String columnName) {
        int index = this._tcm.getColumnIndex(columnName);
        if (index > -1) {
            TableColumn column = this._tcm.getColumn(index);
            IndexedColumn ic = new IndexedColumn(index, column);
            if (this._hidden.put(columnName, ic) != null) {
                throw new IllegalArgumentException("Duplicate column name.");
            }
            this._tcm.removeColumn(column);
        }
    }

    public void show(int index) {
        TableColumn column;
        IndexedColumn ic;
        if (index > -1 && (ic = (IndexedColumn)this._hidden.remove((column = this._tcm.getColumn(index)).getHeaderValue().toString())) != null) {
            this._tcm.addColumn(ic.column);
            if (this._reorder) {
                int lastColumn = this._tcm.getColumnCount() - 1;
                if (ic.index < lastColumn) {
                    this._tcm.moveColumn(lastColumn, ic.index);
                }
            }
        }
    }

    public void show(String columnName) {
        IndexedColumn ic = (IndexedColumn)this._hidden.remove(columnName);
        if (ic != null) {
            this._tcm.addColumn(ic.column);
            if (this._reorder) {
                int lastColumn = this._tcm.getColumnCount() - 1;
                if (ic.index < lastColumn) {
                    this._tcm.moveColumn(lastColumn, ic.index);
                }
            }
        }
    }

    public static void main(String[] args) {
        Object[] columnNames = new String[]{"Name", "Size", "Type", "Date Modified", "Permissions"};
        Object[][] data = new String[][]{{"bin", "2", "dir", "Jun 9", "drwxr-xr-x"}, {"boot", "3", "dir", "Jun 9", "drwxr-xr-x"}, {"dev", "6", "dir", "Jul 12", "drwxr-xr-x"}, {"etc", "34", "dir", "Jul 12", "drwxr-xr-x"}};
        JTable table = new JTable(data, columnNames);
        table.setPreferredScrollableViewportSize(table.getPreferredSize());
        JScrollPane scrollPane = new JScrollPane(table);
        final TableColumnHider hider = new TableColumnHider(table);
        JPanel checkBoxes = new JPanel();
        for (int i = 0; i < columnNames.length; ++i) {
            JCheckBox checkBox = new JCheckBox((String)columnNames[i]);
            checkBox.setSelected(true);
            checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    JCheckBox cb = (JCheckBox)evt.getSource();
                    String columnName = cb.getText();
                    if (cb.isSelected()) {
                        hider.show(columnName);
                    } else {
                        hider.hide(columnName);
                    }
                }
            });
            checkBoxes.add(checkBox);
        }
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(scrollPane);
        frame.getContentPane().add((Component)checkBoxes, "South");
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    private static class IndexedColumn {
        private Integer index;
        private TableColumn column;

        public IndexedColumn(Integer index, TableColumn column) {
            this.index = index;
            this.column = column;
        }
    }
}

