/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.table.TableRowSorter;
import rma.swing.RmaImage;
import rma.swing.RmaInsets;
import rma.swing.table.TableRowFilterDialog;
import rma.util.RMAIO;

public class TableHeaderFilterPanel
extends JPanel {
    private JButton _filterBtn;
    private JButton _clearFilterBtn;
    private TableRowFilterDialog _filterDialog;
    private String _filterBtnToolTip;
    private JTable _table;
    private String _title;
    private ImageIcon _defaultImg;
    private ImageIcon _searchImg;

    public TableHeaderFilterPanel(JTable table, String title) {
        super(new GridBagLayout());
        this._table = table;
        this._title = title;
        this.buildControls(title);
        this.addListeners();
    }

    private void buildControls(String title) {
        JLabel label = new JLabel(title);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.001;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)label, gbc);
        this._defaultImg = RmaImage.getImageIcon("Images/Search.gif");
        this._searchImg = RmaImage.getImageIcon("Images/SearchBlue.gif");
        this._filterBtn = new JButton(this._defaultImg);
        this._filterBtn.setToolTipText("Filter Table Contents");
        this._filterBtnToolTip = this._filterBtn.getToolTipText();
        this._filterBtn.setMargin(RmaInsets.INSETS0000);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 12;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._filterBtn, gbc);
        this._clearFilterBtn = new JButton(RmaImage.getImageIcon("Images/NoSearch.gif"));
        this._clearFilterBtn.setEnabled(false);
        this._clearFilterBtn.setMargin(RmaInsets.INSETS0000);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 12;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._clearFilterBtn, gbc);
    }

    protected void addListeners() {
        this._filterBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableHeaderFilterPanel.this.filterTableAction();
            }
        });
        this._clearFilterBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableHeaderFilterPanel.this.clearTableFilterAction();
            }
        });
    }

    protected void clearTableFilterAction() {
        if (this._table.getRowSorter() == null || ((TableRowSorter)this._table.getRowSorter()).getRowFilter() == null) {
            return;
        }
        ((TableRowSorter)this._table.getRowSorter()).setRowFilter(null);
    }

    protected void filterTableAction() {
        if (this._filterDialog == null) {
            this.initFilterDialog();
        }
        TableRowSorter sorter = (TableRowSorter)this._table.getRowSorter();
        sorter.addRowSorterListener(new RowSorterListener(){

            @Override
            public void sorterChanged(RowSorterEvent e) {
                if (TableHeaderFilterPanel.this._table.getRowSorter() == null || ((TableRowSorter)TableHeaderFilterPanel.this._table.getRowSorter()).getRowFilter() == null) {
                    TableHeaderFilterPanel.this._clearFilterBtn.setEnabled(false);
                } else {
                    TableHeaderFilterPanel.this._clearFilterBtn.setEnabled(true);
                }
                String filter = TableHeaderFilterPanel.this._filterDialog.getFilter();
                if (filter == null || filter.length() == 0 || !TableHeaderFilterPanel.this._clearFilterBtn.isEnabled()) {
                    TableHeaderFilterPanel.this._filterBtn.setToolTipText(TableHeaderFilterPanel.this._filterBtnToolTip);
                    TableHeaderFilterPanel.this._filterBtn.setIcon(TableHeaderFilterPanel.this._defaultImg);
                } else {
                    String htmlFilter = RMAIO.toHtmlString(filter);
                    TableHeaderFilterPanel.this._filterBtn.setToolTipText(htmlFilter);
                    TableHeaderFilterPanel.this._filterBtn.setIcon(TableHeaderFilterPanel.this._searchImg);
                }
            }
        });
        Dimension size = this._filterDialog.getSize();
        Point p = this._filterBtn.getLocationOnScreen();
        int x = p.x - size.width + this._filterBtn.getSize().width;
        Point newP = new Point(x, p.y);
        if (this.getGraphicsConfiguration() != null && !this.getGraphicsConfiguration().getBounds().contains(newP)) {
            newP = p;
        }
        this._filterDialog.setLocation(newP);
        this._filterDialog.setVisible(true);
    }

    private void initFilterDialog() {
        Window w = SwingUtilities.windowForComponent(this);
        this._filterDialog = w instanceof JDialog ? new TableRowFilterDialog((JDialog)w, this._table, "Filter " + this._title) : new TableRowFilterDialog((JFrame)w, this._table, "Filter " + this._title);
    }

    public void setFilter(String name, String selection) {
        if (this._filterDialog == null) {
            this.initFilterDialog();
        }
        this._filterDialog.setFilter(name, selection);
        this._clearFilterBtn.setEnabled(true);
    }
}

