/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import rma.swing.table.HeaderPrintCellRendererPane;
import rma.swing.table.PrintUI;
import rma.swing.table.TablePrintProperties;

public class TableHeaderPrintUI
extends BasicTableHeaderUI
implements PrintUI {
    @Override
    public void installUI(JComponent aJComponent) {
        this.header = (JTableHeader)aJComponent;
        this.rendererPane = new HeaderPrintCellRendererPane();
    }

    @Override
    public void setProperties(TablePrintProperties p) {
        if (this.rendererPane instanceof HeaderPrintCellRendererPane) {
            ((HeaderPrintCellRendererPane)this.rendererPane).setPrintProperties(p);
        }
    }

    @Override
    public void paint(Graphics g, JComponent c2) {
        if (this.header.getColumnModel().getColumnCount() <= 0) {
            return;
        }
        Rectangle clip = g.getClipBounds();
        TableColumnModel cm = this.header.getColumnModel();
        int cMin = cm.getColumnIndexAtX(clip.x);
        int cMax = cm.getColumnIndexAtX(clip.x + clip.width - 1);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = cm.getColumnCount() - 1;
        }
        TableColumn draggedColumn = this.header.getDraggedColumn();
        Rectangle cellRect = this.header.getHeaderRect(cMin);
        for (int column = cMin; column <= cMax; ++column) {
            int columnWidth;
            TableColumn aColumn = cm.getColumn(column);
            cellRect.width = columnWidth = aColumn.getWidth();
            Rectangle tempRect = new Rectangle(cellRect);
            if (column != cMin) {
                --tempRect.x;
                ++tempRect.width;
            }
            ++tempRect.height;
            this.paintCell(g, tempRect, column);
            cellRect.x += columnWidth;
        }
        this.rendererPane.removeAll();
    }

    private Component getHeaderRenderer(int columnIndex) {
        TableColumn aColumn = this.header.getColumnModel().getColumn(columnIndex);
        TableCellRenderer renderer = aColumn.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.header.getDefaultRenderer();
        }
        return renderer.getTableCellRendererComponent(this.header.getTable(), aColumn.getHeaderValue(), false, false, -1, columnIndex);
    }

    private void paintCell(Graphics g, Rectangle cellRect, int columnIndex) {
        Component component = this.getHeaderRenderer(columnIndex);
        this.rendererPane.paintComponent(g, component, this.header, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
    }
}

