/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import rma.swing.DefaultJPanel;
import rma.swing.PrintPreview;
import rma.swing.RmaJTable;
import rma.swing.table.AccessTable;
import rma.swing.table.GroupableHeaderPrintUI;
import rma.swing.table.GroupableTableHeader;
import rma.swing.table.HeaderFooterPrintSetupPanel;
import rma.swing.table.PagePrintSetupPanel;
import rma.swing.table.PrintPropertiesDlg;
import rma.swing.table.PrintUI;
import rma.swing.table.TableHeaderPrintUI;
import rma.swing.table.TablePrintProperties;
import rma.swing.table.TablePrintUI;
import rma.swing.table.TitlePageSetupPanel;

public class TablePrintManager
implements Printable,
Pageable {
    Hashtable m_printUI;
    JTable m_table = new JTable(new String[][]{{"0,0", "1,0"}}, new String[]{"col 1", "col 2"});
    JTable m_fixedRowTable = null;
    int m_maxNumPage;
    TablePrintProperties m_properties = new TablePrintProperties();
    PageFormat m_pageFormat = null;
    boolean m_fixedColumnTable = false;
    TablePrintManager m_fixedColumnPrintManager = null;
    double[] subTableSplit = null;
    double[] m_tableHeightOnFullPage;
    int m_subTableSplitSize = 0;
    int m_subPageIndex = 0;
    int prevPageIndex = 0;
    int m_pages = 1;
    Font m_printFont = null;
    int fontHeight;
    int fontDesent;
    int pageHeight;
    int pageWidth;
    int tableWidth;
    int headerWidth;
    int m_tableHeaderHeight;
    double m_fixedColumnWidth = 0.0;
    int m_startRowOffset = 0;
    double m_tableHeight;
    double m_rowHeight;
    int m_headerHeight = 0;
    int m_footerHeight = 0;
    int m_titleHeight = 0;
    int m_subTitleHeight = 0;
    boolean m_pageDone;
    double m_scale = 1.0;
    JList m_headerList;
    JList m_footerList;
    JList m_titleList;
    JList m_subTitleList;
    Date m_printDate = null;

    private void registerDefaults() {
        this.m_printUI = new Hashtable();
        this.registerPrintUI(JTable.class, new TablePrintUI());
        this.registerPrintUI(RmaJTable.class, new TablePrintUI());
        this.registerPrintUI(AccessTable.class, new TablePrintUI());
        this.registerPrintUI(JTableHeader.class, new TableHeaderPrintUI());
        this.registerPrintUI(GroupableTableHeader.class, new GroupableHeaderPrintUI());
    }

    public TablePrintManager(JTable table) {
        this.setTable(table);
    }

    public void setTable(JTable table) {
        if (table == null) {
            return;
        }
        this.m_table = table;
        this.registerDefaults();
        this.getPrintUI(this.m_table.getClass()).installUI(this.m_table);
        this.getPrintUI(this.m_table.getTableHeader().getClass()).installUI(this.m_table.getTableHeader());
    }

    public void setFixedColumnTable(boolean fixed) {
        this.m_fixedColumnTable = fixed;
    }

    public void registerPrintUI(Class c2, PrintUI ui) {
        this.m_printUI.put(c2, ui);
    }

    public PrintUI getPrintUI(Class c2) {
        PrintUI pui = (PrintUI)this.m_printUI.get(c2);
        if (pui == null) {
            return this.getPrintUI(c2.getSuperclass());
        }
        return pui;
    }

    public void setPrintProperties(TablePrintProperties prop) {
        if (prop != null) {
            this.m_properties = prop;
        }
    }

    public TablePrintProperties getPrintProperties() {
        return this.m_properties;
    }

    public boolean showPropertiesDialog(String type) {
        PrintPropertiesDlg dlg;
        HeaderFooterPrintSetupPanel panel2 = new HeaderFooterPrintSetupPanel();
        panel2.setData(this.m_properties);
        PagePrintSetupPanel panel1 = new PagePrintSetupPanel();
        this.m_properties.enableFixedColumns = this.getFixedColumnWidth() > 0;
        this.m_properties.printSelection = TablePrintProperties.ENTIRE_TABLE;
        if (this.m_table.getSelectedColumnCount() > 1 || this.m_table.getSelectedRowCount() > 1) {
            this.m_properties.printSelection = TablePrintProperties.SELECTED_CELLS;
        }
        panel1.setData(this.m_properties);
        TitlePageSetupPanel panel3 = new TitlePageSetupPanel();
        panel3.setData(this.m_properties);
        Window w = SwingUtilities.windowForComponent(this.m_table);
        DefaultJPanel[] panelList = new DefaultJPanel[]{panel1, panel2, panel3};
        if (w instanceof Frame) {
            if (this.m_properties.useDefaultPrintHeader) {
                panel3.setDefaultTitle(((Frame)w).getTitle());
            }
            dlg = new PrintPropertiesDlg((Frame)w, true, "Properties", panelList);
        } else if (w instanceof Dialog) {
            if (this.m_properties.useDefaultPrintHeader) {
                panel3.setDefaultTitle(((Dialog)w).getTitle());
            }
            dlg = new PrintPropertiesDlg((Dialog)w, true, "Properties", panelList);
        } else {
            dlg = new PrintPropertiesDlg((Frame)null, true, "Properties", panelList);
        }
        dlg.setPrintButtonText(type);
        dlg.pack();
        Dimension d = dlg.getPreferredSize();
        int xLoc = this.m_table.getBounds().x + (int)(d.getWidth() / 2.0);
        int yLoc = this.m_table.getBounds().y + (int)(d.getHeight() / 2.0);
        dlg.setLocation(xLoc, yLoc);
        dlg.setVisible(true);
        return !dlg.isCanceled();
    }

    public void printPreview() {
        this.printPreview(false);
    }

    public boolean printPreview(boolean printSilently) {
        if (!printSilently && !this.showPropertiesDialog("Preview")) {
            return false;
        }
        this.m_pageDone = false;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Window window = SwingUtilities.windowForComponent(TablePrintManager.this.m_table);
                Frame frame = null;
                if (window instanceof Frame) {
                    frame = (Frame)window;
                }
                new PrintPreview((Frame)null, (Printable)TablePrintManager.this, "Print Preview");
            }
        });
        thread.start();
        return true;
    }

    public void printData() {
        this.printData(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean printData(boolean printSilently) {
        if (!printSilently && !this.showPropertiesDialog("Print")) {
            return false;
        }
        this.m_pageDone = false;
        PrinterJob prnJob = null;
        try {
            prnJob = PrinterJob.getPrinterJob();
            prnJob.setPageable(this);
            if (!printSilently && !prnJob.printDialog()) {
                boolean bl = false;
                return bl;
            }
            this.m_maxNumPage = 1;
            prnJob.print();
            boolean bl = true;
            return bl;
        }
        catch (PrinterException e) {
            e.printStackTrace();
            System.err.println("Printing error: " + e.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            if (prnJob != null) {
                // empty if block
            }
        }
    }

    public JTable getFixedColumns() {
        Container c2 = this.m_table.getParent();
        if (!(c2 instanceof JViewport)) {
            return null;
        }
        if (!((c2 = c2.getParent()) instanceof JScrollPane)) {
            return null;
        }
        JScrollPane sPane = (JScrollPane)c2;
        JViewport rowHeader = sPane.getRowHeader();
        if (rowHeader == null) {
            return null;
        }
        Component comp = rowHeader.getView();
        if (!(comp instanceof JTable)) {
            return null;
        }
        if (comp == this.m_table) {
            return null;
        }
        return (JTable)comp;
    }

    public int getFixedColumnWidth() {
        JTable table = this.getFixedColumns();
        if (table == null) {
            return 0;
        }
        return table.getColumnModel().getTotalColumnWidth();
    }

    @Override
    public int getNumberOfPages() {
        this.getPageInfo(this.getPageFormat(0));
        this.m_pageDone = true;
        return this.m_pages;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) {
        if (this.m_pageFormat == null) {
            this.m_pageFormat = new PageFormat();
        }
        this.m_pageFormat.setOrientation(this.m_properties.orientation == TablePrintProperties.PORTRAIT ? 1 : 0);
        if (this.m_properties.expandPageToFitTable) {
            this.m_headerList = new JList();
            this.m_footerList = new JList();
            this.m_titleList = new JList();
            this.m_subTitleList = new JList();
            this.parseString(this.m_headerList, this.m_properties.header);
            this.parseString(this.m_footerList, this.m_properties.footer);
            this.parseString(this.m_titleList, this.m_properties.title);
            this.parseString(this.m_subTitleList, this.m_properties.subTitle, 2);
            int headerHeight = this.m_headerList.getPreferredSize().height;
            int footerHeight = this.m_footerList.getPreferredSize().height;
            int titleHeight = this.m_titleList.getPreferredSize().height;
            int subTitleHeight = this.m_subTitleList.getPreferredSize().height;
            JTableHeader tableHeader = this.m_table.getTableHeader();
            int tableHeaderHeight = tableHeader.getHeight() + this.m_table.getRowMargin();
            int tableRowHeight = 0;
            for (int i = 0; i < this.m_table.getRowCount(); ++i) {
                tableRowHeight += this.m_table.getRowHeight(i);
            }
            int newHeight = tableHeaderHeight + subTitleHeight + titleHeight + footerHeight + headerHeight + tableRowHeight + 10;
            Paper oldPaper = this.m_pageFormat.getPaper();
            Paper newPaper = new Paper();
            int yMarginSize = (int)(oldPaper.getHeight() - oldPaper.getImageableHeight()) / 2;
            int xMarginSize = (int)(oldPaper.getWidth() - oldPaper.getImageableWidth()) / 2;
            newPaper.setSize(oldPaper.getWidth(), newHeight + 2 * yMarginSize);
            newPaper.setImageableArea(xMarginSize, yMarginSize, newPaper.getWidth() - (double)(2 * xMarginSize), newPaper.getHeight() - (double)(2 * yMarginSize));
            this.m_pageFormat.setPaper(newPaper);
        }
        return this.m_pageFormat;
    }

    public void setPageFormat(int index, PageFormat pf) {
        this.m_pageFormat = pf;
    }

    @Override
    public Printable getPrintable(int page) {
        return this;
    }

    private int validRowCount() {
        int lastValidRowsForTable = 0;
        int lastValidRowInCol = 0;
        for (int col = 0; col < this.m_table.getColumnCount(); ++col) {
            lastValidRowInCol = 0;
            for (int row = 0; row < this.m_table.getRowCount(); ++row) {
                Object obj = this.m_table.getValueAt(row, col);
                if (obj == null || obj.toString().equals("")) continue;
                lastValidRowInCol = row + 1;
            }
            if (lastValidRowInCol <= lastValidRowsForTable) continue;
            lastValidRowsForTable = lastValidRowInCol;
        }
        return lastValidRowsForTable;
    }

    private int getSelectionHeight() {
        int validHeight = 0;
        if (this.m_properties.printSelection == TablePrintProperties.ENTIRE_TABLE || this.m_table.getSelectedRowCount() < 1) {
            int validRowCount = this.validRowCount();
            for (int i = 0; i < validRowCount; ++i) {
                validHeight += this.m_table.getRowHeight(i);
            }
            return validHeight;
        }
        int[] selectedRows = this.m_table.getSelectedRows();
        validHeight = 0;
        for (int i = 0; i < selectedRows.length; ++i) {
            validHeight += this.m_table.getRowHeight(selectedRows[i]);
        }
        return validHeight;
    }

    private int getSelectionWidth() {
        if (this.m_properties.printSelection == TablePrintProperties.ENTIRE_TABLE) {
            return this.m_table.getColumnModel().getTotalColumnWidth();
        }
        int width = 0;
        int startColumn = this.getStartingColumn();
        int endColumn = startColumn + this.getColumnCount();
        for (int i = startColumn; i < endColumn; ++i) {
            TableColumn tc = this.m_table.getColumnModel().getColumn(i);
            if (tc == null) continue;
            width += tc.getWidth();
        }
        return width;
    }

    private int getColumnCount() {
        if (this.m_properties.printSelection == TablePrintProperties.ENTIRE_TABLE) {
            return this.m_table.getColumnCount();
        }
        int[] selectedColumns = this.m_table.getSelectedColumns();
        if (selectedColumns == null || selectedColumns.length == 0 || this.m_table.getRowSelectionAllowed() && !this.m_table.getColumnSelectionAllowed()) {
            return this.m_table.getColumnCount();
        }
        return selectedColumns.length;
    }

    private int getRowCount() {
        if (this.m_properties.printSelection == TablePrintProperties.ENTIRE_TABLE) {
            return this.validRowCount();
        }
        int[] selectedRows = this.m_table.getSelectedRows();
        if (selectedRows == null || selectedRows.length == 0) {
            return this.validRowCount();
        }
        return selectedRows.length;
    }

    private int getStartingColumn() {
        if (this.m_properties.printSelection == TablePrintProperties.ENTIRE_TABLE) {
            return 0;
        }
        int[] selectedColumns = this.m_table.getSelectedColumns();
        if (selectedColumns == null || selectedColumns.length == 0 || this.m_table.getRowSelectionAllowed() && !this.m_table.getColumnSelectionAllowed()) {
            return 0;
        }
        return selectedColumns[0];
    }

    private int getStartingRow() {
        if (this.m_properties.printSelection == TablePrintProperties.ENTIRE_TABLE) {
            return 0;
        }
        int[] selectedRows = this.m_table.getSelectedRows();
        if (selectedRows == null || selectedRows.length == 0) {
            return 0;
        }
        return selectedRows[0];
    }

    private int getStartingPrintWidthOffset() {
        if (this.m_properties.printSelection == TablePrintProperties.ENTIRE_TABLE) {
            return 0;
        }
        int width = 0;
        for (int i = 0; i < this.getStartingColumn(); ++i) {
            TableColumn tc = this.m_table.getColumnModel().getColumn(i);
            if (tc == null) continue;
            width += tc.getWidth();
        }
        return width;
    }

    private int getStartingPrintHeightOffset() {
        if (this.m_properties.printSelection == TablePrintProperties.ENTIRE_TABLE) {
            return 0;
        }
        int validHeight = 0;
        int startRow = this.getStartingRow();
        for (int i = 0; i < startRow; ++i) {
            validHeight += this.m_table.getRowHeight(i);
        }
        return validHeight;
    }

    private void parseString(JList list, String text, int align) {
        list.setBackground(Color.white);
        list.setForeground(Color.black);
        if (text == null) {
            return;
        }
        StringTokenizer strTok = new StringTokenizer(text, "\n", false);
        DefaultListModel<Object> model = new DefaultListModel<Object>();
        int tokenCount = strTok.countTokens();
        for (int i = 0; i < tokenCount; ++i) {
            model.addElement(strTok.nextElement());
        }
        list.setModel(model);
        DefaultListCellRenderer renderer = new DefaultListCellRenderer();
        renderer.setHorizontalAlignment(align);
        list.setCellRenderer(renderer);
    }

    private void parseString(JList list, String text) {
        this.parseString(list, text, 0);
    }

    public void getPageInfo(PageFormat pageFormat) {
        int columnIndex;
        int i;
        this.m_subPageIndex = 0;
        this.subTableSplit = null;
        this.m_subTableSplitSize = 0;
        this.m_subPageIndex = 0;
        this.prevPageIndex = 0;
        this.m_headerList = new JList();
        this.m_footerList = new JList();
        this.m_titleList = new JList();
        this.m_subTitleList = new JList();
        this.m_scale = 1.0;
        this.m_fixedColumnWidth = this.getFixedColumnWidth();
        int selectionWidth = this.getSelectionWidth();
        if ((double)selectionWidth + this.m_fixedColumnWidth > pageFormat.getImageableWidth() && this.m_properties.scaleColumnsToPage) {
            this.m_scale = pageFormat.getImageableWidth() / ((double)selectionWidth + this.m_fixedColumnWidth);
        }
        this.m_fixedColumnWidth *= this.m_scale;
        this.parseString(this.m_headerList, this.m_properties.header);
        this.parseString(this.m_footerList, this.m_properties.footer);
        this.parseString(this.m_titleList, this.m_properties.title);
        this.parseString(this.m_subTitleList, this.m_properties.subTitle, 2);
        this.m_headerHeight = this.m_headerList.getPreferredSize().height;
        this.m_footerHeight = this.m_footerList.getPreferredSize().height;
        this.m_titleHeight = this.m_titleList.getPreferredSize().height;
        this.m_subTitleHeight = this.m_subTitleList.getPreferredSize().height;
        JTableHeader tableHeader = this.m_table.getTableHeader();
        this.headerWidth = tableHeader.getWidth();
        this.m_tableHeaderHeight = (int)((double)(tableHeader.getHeight() + this.m_table.getRowMargin()) * this.m_scale);
        this.pageHeight = (int)pageFormat.getImageableHeight();
        this.pageWidth = (int)(pageFormat.getImageableWidth() - this.m_fixedColumnWidth);
        this.tableWidth = this.getSelectionWidth();
        this.m_tableHeight = (double)this.getSelectionHeight() * this.m_scale;
        this.m_rowHeight = (double)this.m_table.getRowHeight() * this.m_scale;
        double maxHeightForTable = this.pageHeight - this.m_tableHeaderHeight - (this.m_headerHeight + this.m_footerHeight) - (this.m_titleHeight + this.m_subTitleHeight);
        this.m_startRowOffset = (int)((double)this.getStartingPrintHeightOffset() * this.m_scale);
        double[] tempPageHeight = new double[this.m_table.getRowCount() + 500];
        tempPageHeight[0] = this.m_startRowOffset;
        double sumRowHeight = 0.0;
        int index = 0;
        int pageDownCnt = 1;
        double cutoffPos = maxHeightForTable;
        int startRow = this.getStartingRow();
        int endRow = startRow + this.getRowCount();
        boolean adjustedForHeaderAddBack = false;
        boolean adjustedForTitleAddBack = false;
        for (i = startRow; i < endRow; ++i) {
            double rowHeight = (double)this.m_table.getRowHeight(i) * this.m_scale;
            if (rowHeight + sumRowHeight > cutoffPos) {
                tempPageHeight[index + 1] = tempPageHeight[index] + sumRowHeight;
                sumRowHeight = 0.0;
                sumRowHeight += rowHeight;
                ++index;
                ++pageDownCnt;
                if (!this.m_properties.repeatHeaders && !adjustedForHeaderAddBack) {
                    cutoffPos += (double)this.m_tableHeaderHeight;
                    adjustedForHeaderAddBack = true;
                }
                if (this.m_properties.repeatTitle || adjustedForTitleAddBack) continue;
                cutoffPos += (double)(this.m_titleHeight + this.m_subTitleHeight);
                adjustedForTitleAddBack = true;
                continue;
            }
            sumRowHeight += rowHeight;
        }
        if (sumRowHeight > 0.0) {
            int n = index + 1;
            tempPageHeight[n] = tempPageHeight[n] + (tempPageHeight[index] + sumRowHeight);
            ++index;
        }
        if (index == 0) {
            ++index;
        }
        this.m_tableHeightOnFullPage = new double[index + 1];
        for (i = 0; i < this.m_tableHeightOnFullPage.length; ++i) {
            this.m_tableHeightOnFullPage[i] = tempPageHeight[i];
        }
        TableColumnModel tableColumnModel = tableHeader.getColumnModel();
        int columns = columnIndex + this.getColumnCount();
        TableColumn tableColumn = null;
        tableColumnModel.getColumnMargin();
        double[] temp = new double[500];
        temp[0] = (double)this.getStartingPrintWidthOffset() * this.m_scale;
        double length = 0.0;
        this.m_subTableSplitSize = 0;
        int pageAcrossCnt = 1;
        cutoffPos = this.pageWidth;
        for (columnIndex = this.getStartingColumn(); columnIndex < columns; ++columnIndex) {
            tableColumn = tableColumnModel.getColumn(columnIndex);
            double columnWidth = (double)tableColumn.getWidth() * this.m_scale;
            if (Boolean.getBoolean("PRINT_DEBUG")) {
                System.out.println("Col " + columnIndex + " Width=" + tableColumn.getWidth() + " * Scale=" + this.m_scale + " == ColumnWidth=" + columnWidth);
            }
            if ((double)((int)(length + columnWidth)) > cutoffPos) {
                if (length == 0.0) {
                    length = columnWidth;
                }
                temp[this.m_subTableSplitSize + 1] = temp[this.m_subTableSplitSize] + length;
                length = columnWidth;
                ++this.m_subTableSplitSize;
                ++pageAcrossCnt;
                if (this.m_properties.repeatFixColumns) continue;
                cutoffPos += this.m_fixedColumnWidth;
                continue;
            }
            length += columnWidth;
        }
        if (length > 0.0) {
            temp[this.m_subTableSplitSize + 1] = temp[this.m_subTableSplitSize] + length;
            ++this.m_subTableSplitSize;
        }
        ++this.m_subTableSplitSize;
        this.subTableSplit = new double[this.m_subTableSplitSize];
        for (int i2 = 0; i2 < this.m_subTableSplitSize; ++i2) {
            this.subTableSplit[i2] = temp[i2];
        }
        int pagesDown = this.m_tableHeightOnFullPage.length - 1;
        int pagesAcross = this.m_subTableSplitSize - 1;
        this.m_pages = pagesAcross * pagesDown;
        this.m_pageDone = true;
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (!this.m_pageDone) {
            this.getPageInfo(this.getPageFormat(pageIndex));
        }
        this.m_printDate = null;
        if (pageIndex >= this.m_pages) {
            this.m_pageDone = false;
            this.m_fixedColumnPrintManager = null;
            return 1;
        }
        if (this.prevPageIndex != pageIndex) {
            ++this.m_subPageIndex;
            if (this.m_subPageIndex == this.m_subTableSplitSize - 1) {
                this.m_subPageIndex = 0;
            }
        }
        int X = (int)pageFormat.getImageableX();
        int Y = (int)pageFormat.getImageableY();
        g.translate(X, Y);
        int rowIndex = pageIndex / (this.m_subTableSplitSize - 1);
        Graphics2D g2d = (Graphics2D)g;
        if (this.m_footerHeight > 0 && !this.m_fixedColumnTable) {
            this.replacePageCodes(this.m_footerList, this.m_properties.footer, pageIndex + 1);
            double footerScale = 1.0;
            if ((double)this.m_footerList.getPreferredSize().width > pageFormat.getImageableWidth()) {
                footerScale = pageFormat.getImageableWidth() / (double)this.m_footerList.getPreferredSize().width;
            }
            this.m_footerList.getPreferredSize();
            g2d.translate(0.0, pageFormat.getImageableHeight() - (double)this.m_footerHeight);
            Rectangle rect = new Rectangle(1, 0, (int)pageFormat.getImageableWidth(), this.m_footerHeight);
            this.m_footerList.setBounds(rect);
            g2d.setClip(rect.x, rect.y, rect.width, rect.height);
            g2d.scale(footerScale, footerScale);
            this.m_footerList.paint(g);
            g2d.scale(1.0 / footerScale, 1.0 / footerScale);
            g2d.setClip(0, 0, (int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight());
            g2d.translate(0.0, -(pageFormat.getImageableHeight() - (double)this.m_footerHeight));
        }
        if (this.m_headerHeight > 0 && !this.m_fixedColumnTable) {
            double headerScale = 1.0;
            this.replacePageCodes(this.m_headerList, this.m_properties.header, pageIndex + 1);
            if ((double)this.m_headerList.getPreferredSize().width > pageFormat.getImageableWidth()) {
                headerScale = pageFormat.getImageableWidth() / (double)this.m_headerList.getPreferredSize().width;
            }
            g2d.scale(headerScale, headerScale);
            Dimension d = this.m_headerList.getPreferredSize();
            Rectangle rect = new Rectangle(0, 0, (int)pageFormat.getImageableWidth(), d.height);
            this.m_headerList.setBounds(rect);
            g2d.setClip(rect);
            this.m_headerList.paint(g);
            g2d.scale(1.0 / headerScale, 1.0 / headerScale);
            g2d.translate(0, this.m_headerHeight);
        }
        if (this.m_titleHeight > 0 && (rowIndex == 0 || this.m_properties.repeatTitle) && !this.m_fixedColumnTable) {
            this.printList(g2d, pageFormat, this.m_titleList);
        }
        if (this.m_subTitleHeight > 0 && (rowIndex == 0 || this.m_properties.repeatTitle) && !this.m_fixedColumnTable) {
            this.printList(g2d, pageFormat, this.m_subTitleList);
        }
        this.printSubTable(g2d, pageFormat, rowIndex, this.m_subPageIndex);
        this.prevPageIndex = pageIndex;
        return 0;
    }

    private void printList(Graphics2D g2d, PageFormat pageFormat, JList list) {
        double listScale = 1.0;
        Dimension d = list.getPreferredSize();
        if ((double)d.width > pageFormat.getImageableWidth()) {
            listScale = pageFormat.getImageableWidth() / (double)d.width;
        }
        g2d.scale(listScale, listScale);
        Rectangle rect = new Rectangle(0, 0, (int)pageFormat.getImageableWidth(), d.height);
        list.setBounds(rect);
        g2d.setClip(rect);
        list.paint(g2d);
        g2d.scale(1.0 / listScale, 1.0 / listScale);
        g2d.translate(0, d.height);
    }

    public void printSubTable(Graphics2D g, PageFormat pageFormat, int rowIndex, int columnIndex) {
        int scaleError;
        if (Boolean.getBoolean("DEBUG")) {
            Color oldColor = g.getColor();
            g.setColor(oldColor);
        }
        int pageLeft = (int)this.subTableSplit[columnIndex];
        int pgWidth = (int)this.subTableSplit[columnIndex + 1] - (int)this.subTableSplit[columnIndex];
        int pgHeight = (int)this.m_tableHeightOnFullPage[rowIndex + 1] - (int)this.m_tableHeightOnFullPage[rowIndex];
        int clipWidth = Math.min(pgWidth, (int)pageFormat.getImageableWidth());
        int clipHeight = Math.min(pgHeight, (int)pageFormat.getImageableHeight());
        int n = scaleError = this.m_scale == 1.0 ? 0 : 1;
        if (this.m_fixedColumnWidth > 0.0 && (this.m_properties.repeatFixColumns || columnIndex == 0)) {
            TablePrintProperties fixProp = new TablePrintProperties();
            try {
                this.m_properties.copyInto(fixProp);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
            if (this.m_fixedColumnPrintManager == null) {
                JTable fixedTable = this.getFixedColumns();
                this.m_fixedColumnPrintManager = new TablePrintManager(fixedTable);
                this.m_fixedColumnPrintManager.setFixedColumnTable(true);
                this.m_fixedColumnPrintManager.setPrintProperties(fixProp);
            }
            PageFormat fixedPf = new PageFormat();
            Paper paper = (Paper)pageFormat.getPaper().clone();
            if (fixProp.orientation == TablePrintProperties.PORTRAIT) {
                paper.setSize(this.m_fixedColumnWidth, paper.getImageableHeight());
                paper.setImageableArea(0.0, pageFormat.getImageableY(), this.m_fixedColumnWidth, paper.getImageableHeight());
                fixedPf.setOrientation(1);
            } else {
                paper.setSize(paper.getImageableWidth(), this.m_fixedColumnWidth);
                paper.setImageableArea(pageFormat.getImageableX(), 0.0, paper.getImageableWidth(), this.m_fixedColumnWidth);
                fixedPf.setOrientation(0);
            }
            fixedPf.setPaper(paper);
            this.m_fixedColumnPrintManager.setPageFormat(0, fixedPf);
            try {
                Graphics fixedG = g.create();
                fixedG.translate(0, (int)(-pageFormat.getImageableY()));
                this.m_fixedColumnPrintManager.print(fixedG, fixedPf, rowIndex);
                fixedG.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            g.translate(this.m_fixedColumnWidth, 0.0);
        }
        g.translate(-this.subTableSplit[columnIndex], 0.0);
        if (this.m_properties.repeatHeaders || rowIndex == 0) {
            g.setClip(pageLeft, 0, clipWidth + scaleError, this.m_tableHeaderHeight + scaleError);
            g.scale(this.m_scale, this.m_scale);
            this.getPrintUI(this.m_table.getTableHeader().getClass()).installUI(this.m_table.getTableHeader());
            this.getPrintUI(this.m_table.getTableHeader().getClass()).setProperties(this.m_properties);
            this.getPrintUI(this.m_table.getTableHeader().getClass()).paint(g, this.m_table.getTableHeader());
            g.scale(1.0 / this.m_scale, 1.0 / this.m_scale);
            g.translate(0, this.m_tableHeaderHeight);
        }
        int yTranslate = (int)this.m_tableHeightOnFullPage[rowIndex];
        g.translate(0, -yTranslate + scaleError);
        g.setClip(pageLeft, yTranslate, clipWidth + scaleError, clipHeight + scaleError);
        g.scale(this.m_scale, this.m_scale);
        this.getPrintUI(this.m_table.getClass()).installUI(this.m_table);
        this.getPrintUI(this.m_table.getClass()).setProperties(this.m_properties);
        this.getPrintUI(this.m_table.getClass()).paint(g, this.m_table);
        g.scale(1.0 / this.m_scale, 1.0 / this.m_scale);
        g.setColor(Color.green);
        g.translate(0, yTranslate);
    }

    private void replacePageCodes(JList list, String str, int pageNum) {
        StringBuffer strBuf = new StringBuffer(str);
        int changeCnt = 0;
        int idx = -1;
        idx = str.indexOf("%p");
        if (idx != -1) {
            strBuf = strBuf.replace(idx, idx + "%p".length(), Integer.toString(pageNum));
            str = strBuf.toString();
            ++changeCnt;
        }
        if ((idx = str.indexOf("%n")) != -1) {
            strBuf = strBuf.replace(idx, idx + "%n".length(), Integer.toString(this.m_pages));
            str = strBuf.toString();
            ++changeCnt;
        }
        if ((idx = str.indexOf("%d")) != -1) {
            if (this.m_printDate == null) {
                this.m_printDate = new Date(System.currentTimeMillis());
            }
            strBuf = strBuf.replace(idx, idx + "%n".length(), this.m_printDate.toString());
            str = strBuf.toString();
            ++changeCnt;
        }
        if (changeCnt == 0) {
            return;
        }
        this.parseString(list, strBuf.toString());
    }

    public double getScale() {
        return this.m_scale;
    }
}

