/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import rma.swing.table.PrintCellRendererPane;
import rma.swing.table.PrintUI;
import rma.swing.table.TablePrintProperties;

public class TablePrintUI
extends BasicTableUI
implements PrintUI {
    TablePrintProperties m_printProperties = null;

    public TablePrintUI() {
        this.rendererPane = new PrintCellRendererPane();
    }

    @Override
    public void installUI(JComponent aJComponent) {
        this.table = (JTable)aJComponent;
        this.rendererPane = new PrintCellRendererPane();
    }

    @Override
    public void setProperties(TablePrintProperties p) {
        this.m_printProperties = p;
        if (this.rendererPane instanceof PrintCellRendererPane) {
            ((PrintCellRendererPane)this.rendererPane).setPrintProperties(this.m_printProperties);
        }
    }

    @Override
    public void paint(Graphics g, JComponent c2) {
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0) {
            return;
        }
        Rectangle clip = g.getClipBounds();
        Point minLocation = clip.getLocation();
        Point maxLocation = new Point(clip.x + clip.width - 1, clip.y + clip.height - 1);
        int rMin = this.table.rowAtPoint(minLocation);
        int rMax = this.table.rowAtPoint(maxLocation);
        if (rMin == -1) {
            rMin = 0;
        }
        if (rMax == -1) {
            rMax = this.table.getRowCount() - 1;
        }
        int cMin = this.table.columnAtPoint(minLocation);
        int cMax = this.table.columnAtPoint(maxLocation);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = this.table.getColumnCount() - 1;
        }
        this.paintCells(g, rMin, rMax, cMin, cMax);
        if (this.m_printProperties.printGridlines) {
            Rectangle minCell = this.table.getCellRect(rMin, cMin, true);
            this.paintGrid(g, rMin, rMax, cMin, cMax);
        }
    }

    private void paintGrid(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        g.setColor(this.table.getGridColor());
        Rectangle minCell = this.table.getCellRect(rMin, cMin, true);
        Rectangle maxCell = this.table.getCellRect(rMax, cMax, true);
        int tableWidth = maxCell.x + maxCell.width;
        int y = minCell.y;
        g.drawLine(0, y, tableWidth - 1, y);
        for (int row = rMin; row <= rMax; ++row) {
            g.drawLine(0, (y += this.table.getRowHeight(row)) - 1, tableWidth - 1, y - 1);
            if (!Boolean.getBoolean("PRINT_DEBUG")) continue;
            System.out.println("Row GridLine (0," + Integer.toString(y - 1) + ") to (" + Integer.toString(tableWidth - 1) + "," + Integer.toString(y - 1) + ")");
        }
        TableColumnModel cm = this.table.getColumnModel();
        int tableHeight = maxCell.y + maxCell.height;
        int x = minCell.x;
        g.drawLine(x, 0, x, tableHeight - 1);
        for (int column = cMin; column <= cMax; ++column) {
            g.drawLine((x += cm.getColumn(column).getWidth()) - 1, 0, x - 1, tableHeight - 1);
            if (!Boolean.getBoolean("PRINT_DEBUG")) continue;
            System.out.println("Column GridLine (" + Integer.toString(x - 1) + ",0) to (" + Integer.toString(x - 1) + "," + Integer.toString(tableHeight - 1) + ")");
        }
    }

    private void paintCells(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        JTableHeader header = this.table.getTableHeader();
        TableColumn draggedColumn = header == null ? null : header.getDraggedColumn();
        TableColumnModel cm = this.table.getColumnModel();
        int columnMargin = cm.getColumnMargin();
        for (int row = rMin; row <= rMax; ++row) {
            Rectangle cellRect = this.table.getCellRect(row, cMin, false);
            for (int column = cMin; column <= cMax; ++column) {
                TableColumn aColumn = cm.getColumn(column);
                int columnWidth = aColumn.getWidth();
                cellRect.width = columnWidth - columnMargin;
                if (Boolean.getBoolean("PRINT_DEBUG")) {
                    System.out.println("Cell (" + row + "," + column + ") Bounds = " + cellRect);
                }
                Rectangle tempRect = new Rectangle(cellRect);
                --tempRect.width;
                this.paintCell(g, tempRect, row, column);
                cellRect.x += columnWidth;
            }
        }
    }

    private void paintCell(Graphics g, Rectangle cellRect, int row, int column) {
        if (this.table.isEditing() && this.table.getEditingRow() == row && this.table.getEditingColumn() == column) {
            Component component = this.table.getEditorComponent();
            component.setBounds(cellRect);
            component.validate();
        } else {
            TableCellRenderer renderer = this.table.getCellRenderer(row, column);
            if (renderer == null) {
                return;
            }
            Object value = this.table.getValueAt(row, column);
            Component component = renderer.getTableCellRendererComponent(this.table, value, false, false, row, column);
            this.rendererPane.paintComponent(g, component, this.table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
        }
    }
}

