/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTable;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaImage;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.table.TableRowFilterPanel;

public class TableRowFilterDialog
extends RmaJDialog {
    private JTable _table;
    private TableRowFilterPanel _filterPanel;
    private ButtonCmdPanel _cmdPanel;
    protected boolean _canceled;

    public TableRowFilterDialog(JDialog parent, JTable table, String title) {
        super((Dialog)parent, true);
        this.setTitle(title);
        this._table = table;
        this.buildControls();
        this.addListeners();
        this.pack();
        Dimension d = this.getSize();
        this.setSize(d.width, d.height + 50);
        this.setLocationRelativeTo(this.getParent());
    }

    public TableRowFilterDialog(JFrame parent, JTable table, String title) {
        super((Frame)parent, true);
        this.setTitle(title);
        this._table = table;
        this.buildControls();
        this.addListeners();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this._filterPanel = new TableRowFilterPanel(this._table);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._filterPanel, gbc);
        this._cmdPanel = new ButtonCmdPanel(12);
        gbc.gridx = 0;
        gbc.gridy = 10;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5555;
        this.getContentPane().add((Component)this._cmdPanel, gbc);
        Image image = RmaImage.loadURLImage("Images/rts32.gif");
        if (image != null) {
            this.setIconImage(image);
        }
    }

    private void addListeners() {
        this._cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            @Override
            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        TableRowFilterDialog.this._filterPanel.filterTableAction();
                        TableRowFilterDialog.this._canceled = false;
                        TableRowFilterDialog.this.setVisible(false);
                        break;
                    }
                    case 4: {
                        TableRowFilterDialog.this._canceled = true;
                        TableRowFilterDialog.this.setVisible(false);
                    }
                }
            }
        });
    }

    public String getFilter() {
        return this._filterPanel.getFilter();
    }

    public void setFilter(String name, String selection) {
        this._filterPanel.setFilter(name, selection);
    }
}

