/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJTextField;
import rma.swing.list.RmaListModel;
import rma.swing.table.WildcardRowFilter;

public class TableRowFilterPanel
extends JPanel {
    private JTable _table;
    private JPanel _filterPanelsPanel;
    private FilterPanel _firstFilterPanel;
    private JButton _searchBtn;
    private JButton _clearBtn;

    public TableRowFilterPanel(JTable table) {
        super(new GridBagLayout());
        if (!(table.getRowSorter() instanceof TableRowSorter)) {
            throw new IllegalStateException("Table must have a TableRowSorter");
        }
        this._table = table;
        this.buildControls();
        this.addListeners();
    }

    private void buildControls() {
        TitledBorder b = BorderFactory.createTitledBorder("");
        this.setBorder(b);
        this._filterPanelsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.5;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS0000;
        this.add((Component)this._filterPanelsPanel, gbc);
        this._firstFilterPanel = new FilterPanel(false);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS0000;
        this._filterPanelsPanel.add((Component)this._firstFilterPanel, gbc);
        JLabel label = new JLabel("");
        gbc.gridx = 0;
        gbc.gridy = 500;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS0000;
        this._filterPanelsPanel.add((Component)label, gbc);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 100;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.01;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)buttonPanel, gbc);
        this._clearBtn = new JButton("Clear");
        gbc.gridx = 0;
        gbc.gridy = 100;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0E-4;
        gbc.anchor = 15;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        buttonPanel.add((Component)this._clearBtn, gbc);
        this._searchBtn = new JButton("Search");
        gbc.gridx = 1;
        gbc.gridy = 100;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0E-4;
        gbc.anchor = 15;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
    }

    private void addListeners() {
        this._searchBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableRowFilterPanel.this.filterTableAction();
            }
        });
        this._clearBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableRowFilterPanel.this.clearSearchAction();
            }
        });
    }

    protected void clearSearchAction() {
        int cnt = this._filterPanelsPanel.getComponentCount();
        for (int i = cnt - 1; i > 0; --i) {
            Component c2 = this._filterPanelsPanel.getComponent(i);
            if (!(c2 instanceof FilterPanel)) continue;
            this._filterPanelsPanel.remove(c2);
        }
        this._filterPanelsPanel.repaint();
        this._firstFilterPanel.setFilter("", "Any Column");
        SwingUtilities.windowForComponent(this).pack();
    }

    public void filterTableAction() {
        int cnt = this._filterPanelsPanel.getComponentCount();
        ArrayList<WildcardRowFilter> filters = new ArrayList<WildcardRowFilter>(cnt);
        for (int i = 0; i < cnt; ++i) {
            Component c2 = this._filterPanelsPanel.getComponent(i);
            if (!(c2 instanceof FilterPanel)) continue;
            FilterPanel fp = (FilterPanel)c2;
            String txt = fp.getSearchText();
            int col = fp.getSearchColumn();
            if (txt.length() <= 0) continue;
            WildcardRowFilter f = new WildcardRowFilter(txt, col);
            filters.add(f);
        }
        RowFilter filter = RowFilter.andFilter(filters);
        ((TableRowSorter)this._table.getRowSorter()).setRowFilter(filter);
    }

    protected void removeFilterPanel(FilterPanel panel) {
        this._filterPanelsPanel.remove(panel);
        Window w = SwingUtilities.windowForComponent(this);
        w.invalidate();
        w.validate();
        w.repaint();
    }

    protected void addFilterPanel(FilterPanel panel) {
        FilterPanel newpanel = new FilterPanel(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = this._filterPanelsPanel.getComponentCount() - 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS0000;
        this._filterPanelsPanel.add((Component)newpanel, gbc);
        Window w = SwingUtilities.windowForComponent(this);
        w.pack();
        w.invalidate();
        w.validate();
        w.repaint();
    }

    public void removeSubsequentFilters() {
        int cnt = this._filterPanelsPanel.getComponentCount();
        if (cnt > 1) {
            for (int i = cnt - 1; i > 1; --i) {
                this.removeFilterPanel((FilterPanel)this._filterPanelsPanel.getComponent(i));
            }
        }
    }

    public void setFilter(String filter, String selection) {
        this.removeSubsequentFilters();
        this._firstFilterPanel.setFilter(filter, selection);
        this.filterTableAction();
    }

    public String getFilter() {
        StringBuffer buf = new StringBuffer();
        int cnt = this._filterPanelsPanel.getComponentCount();
        for (int i = 0; i < cnt; ++i) {
            Component c2 = this._filterPanelsPanel.getComponent(i);
            if (!(c2 instanceof FilterPanel)) continue;
            FilterPanel fp = (FilterPanel)c2;
            String txt = fp.getSearchText();
            int col = fp.getSearchColumn();
            if (txt.length() <= 0) continue;
            if (i > 0) {
                buf.append("\n");
            }
            buf.append(txt);
            buf.append(" in ");
            buf.append(fp.getSearchColumnText());
        }
        return buf.toString();
    }

    private class FilterPanel
    extends JPanel {
        private RmaJTextField _searchTxtFld;
        private RmaJComboBox _columnsCombo;
        private JButton _addButton;
        private JButton _removeButton;

        FilterPanel(boolean addRemoveButtons) {
            super(new GridBagLayout());
            this.buildControls(addRemoveButtons);
            this.fillForm();
            this.addListeners();
        }

        public int getSearchColumn() {
            int idx = this._columnsCombo.getSelectedIndex();
            if (idx == this._columnsCombo.getItemCount() - 1) {
                return -1;
            }
            return idx;
        }

        public String getSearchColumnText() {
            String item = (String)this._columnsCombo.getSelectedItem();
            if (item == null) {
                return "";
            }
            return item;
        }

        public String getSearchText() {
            return this._searchTxtFld.getText();
        }

        protected void buildControls(boolean addRemoveButtons) {
            JLabel txtLabel = new JLabel("Search For:");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.INSETS5505;
            this.add((Component)txtLabel, gbc);
            this._searchTxtFld = new RmaJTextField();
            this._searchTxtFld.setToolTipText("<html>The case insensitive text to search the table for.<br>To perform a 'starts with' search add a '*' to the end.</html>");
            this._searchTxtFld.setColumns(10);
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.INSETS5505;
            this.add((Component)this._searchTxtFld, gbc);
            JLabel inLabel = new JLabel("in");
            gbc.gridx = 3;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.INSETS5505;
            this.add((Component)inLabel, gbc);
            this._columnsCombo = new RmaJComboBox();
            gbc.gridx = 4;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.INSETS5505;
            this.add((Component)this._columnsCombo, gbc);
            this._addButton = new JButton("+");
            this._addButton.setToolTipText("Add another search criteria");
            gbc.gridx = 5;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.INSETS5505;
            gbc.insets = !addRemoveButtons ? RmaInsets.insets(5, 5, 0, this._addButton.getPreferredSize().width + 12) : RmaInsets.INSETS5505;
            this.add((Component)this._addButton, gbc);
            this._removeButton = new JButton("-");
            this._removeButton.setToolTipText("Remove search criteria");
            gbc.gridx = 6;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.INSETS5505;
            if (addRemoveButtons) {
                this.add((Component)this._removeButton, gbc);
            }
        }

        protected void fillForm() {
            TableColumnModel tcm = TableRowFilterPanel.this._table.getColumnModel();
            int colNum = tcm.getColumnCount();
            RmaListModel<String> model = new RmaListModel<String>(false);
            for (int i = 0; i < colNum; ++i) {
                model.addElement(tcm.getColumn(i).getHeaderValue().toString());
            }
            model.addElement("Any Column");
            this._columnsCombo.setModel(model);
            this._columnsCombo.setSelectedIndex(model.getSize() - 1);
        }

        protected void addListeners() {
            this._addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableRowFilterPanel.this.addFilterPanel(FilterPanel.this);
                }
            });
            this._removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableRowFilterPanel.this.removeFilterPanel(FilterPanel.this);
                }
            });
        }

        public void setFilter(String filter, String selection) {
            this._searchTxtFld.setText(filter);
            this._columnsCombo.setSelectedItem(selection);
        }
    }
}

