/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import hec.client.FindTextJDialog;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import rma.swing.RmaJTable;

public class TableSearcher {
    private RmaJTable _table;
    protected int _searchDirection;
    protected String _searchText = "";
    protected FindTextJDialog _findDialog = null;
    protected boolean _matchCase;
    protected boolean _wrapAround;

    public TableSearcher(RmaJTable table) {
        this._table = table;
    }

    public void displayFindDialog() {
        if (this._findDialog == null) {
            Window w = SwingUtilities.windowForComponent(this._table);
            this._findDialog = w instanceof JDialog ? new FindTextJDialog((JDialog)w, true) : new FindTextJDialog((Frame)((JFrame)w), true);
            this._findDialog.setMatchCase(true);
            this._findDialog.setMatchCaseEnabled(true);
            this._findDialog.setWrapAroundEnabled(true);
        }
        this._findDialog.setVisible(true);
        if (this._findDialog.isCanceled()) {
            return;
        }
        this._matchCase = this._findDialog.isMatchCase();
        this._wrapAround = this._findDialog.isWrapAround();
        this._searchDirection = this._findDialog.getSearchDirection();
        this._searchText = this._findDialog.getSearchText();
        this.search();
    }

    public void searchNext() {
        this.search(true);
    }

    public void searchPrevious() {
        this.search(false);
    }

    public void search() {
        this.search(this._searchDirection == 1);
    }

    public void search(boolean searchNext) {
        if (this._findDialog == null) {
            this.displayFindDialog();
            return;
        }
        if (this._searchText == null || this._searchText.length() == 0) {
            System.out.println("no Search text specified");
            return;
        }
        int col = this._table.getSelectedColumn();
        int row = this._table.getSelectedRow();
        if (col < 0) {
            col = 0;
        }
        if (row < 0) {
            row = 0;
        }
        int rowCnt = this._table.getRowCount();
        int colCnt = this._table.getColumnCount();
        boolean found = false;
        String searchStr = this._searchText;
        if (!this._matchCase) {
            searchStr = this._searchText.toLowerCase();
        }
        if (searchNext) {
            int cnt = 0;
            boolean first = true;
            int startRow = row;
            int endRow = rowCnt;
            int startCol = col;
            int endCol = colCnt;
            do {
                for (int r = startRow; r < endRow && !found; ++r) {
                    for (int c2 = startCol; c2 < endCol; ++c2) {
                        if (first) {
                            first = false;
                            continue;
                        }
                        found = this.checkCellContents(r, c2, searchStr);
                        if (!found) continue;
                        this._table.updateSelection(r, c2, false, false);
                        return;
                    }
                }
                if (this._wrapAround) {
                    startRow = 0;
                    endRow = row;
                    startCol = 0;
                    ++cnt;
                    continue;
                }
                cnt += 2;
            } while (cnt < 2);
        } else {
            int cnt = 0;
            boolean first = true;
            int startRow = row;
            int endRow = 0;
            int startCol = colCnt;
            int endCol = 0;
            do {
                for (int r = startRow; r >= endRow && !found; --r) {
                    for (int c3 = startCol; c3 >= endCol; --c3) {
                        if (first) {
                            first = false;
                            continue;
                        }
                        found = this.checkCellContents(r, c3, searchStr);
                        if (!found) continue;
                        this._table.updateSelection(r, c3, false, false);
                        return;
                    }
                }
                if (this._wrapAround) {
                    startRow = rowCnt - 1;
                    endRow = row;
                    startCol = 0;
                    ++cnt;
                    continue;
                }
                cnt += 2;
            } while (cnt < 2);
        }
        if (!found) {
            JOptionPane.showMessageDialog(this._table, "<html>String <b>" + this._searchText + "</b> not found</html>", "Search Failed", 1);
        }
    }

    private boolean checkCellContents(int r, int c2, String searchStr) {
        Object obj = this._table.getValueAt(r, c2);
        if (obj == null) {
            return false;
        }
        String objStr = obj.toString();
        if (!this._matchCase) {
            objStr = objStr.toLowerCase();
        }
        return objStr.contains(searchStr);
    }
}

