/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import java.awt.Component;
import java.util.TimeZone;
import javax.swing.JTable;
import rma.swing.table.MleHeadRenderer;

public class TimeZoneHeaderRenderer
extends MleHeadRenderer {
    private TimeZone m_timeZone;

    public TimeZoneHeaderRenderer() {
    }

    public TimeZoneHeaderRenderer(TimeZone tz) {
        this();
        this.m_timeZone = tz;
    }

    public void setTimeZone(TimeZone tz) {
        this.m_timeZone = tz;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        String newValue = value instanceof String ? this.replaceTimeZoneTemplate((String)value) : this.replaceTimeZoneTemplate(value.toString());
        return super.getTableCellRendererComponent(table, newValue, isSelected, hasFocus, row, column);
    }

    private String replaceTimeZoneTemplate(String value) {
        if (this.m_timeZone == null || value == null) {
            return value;
        }
        int templateIndex = value.indexOf("%S");
        if (templateIndex < 0) {
            return value;
        }
        StringBuffer strBuf = new StringBuffer(value);
        strBuf.replace(templateIndex, templateIndex + "%S".length(), this.m_timeZone.getID());
        return strBuf.toString();
    }
}

