/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.table.TablePrintProperties;

public class TitlePageSetupPanel
extends DefaultJPanel {
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JTextArea m_titleArea = new JTextArea();
    JCheckBox m_repeateTitle = new JCheckBox("Repeat Title on Every Page");
    TablePrintProperties m_properties = null;

    public TitlePageSetupPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getName() {
        return "Table Title";
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        JScrollPane scrollPane = new JScrollPane(this.m_titleArea);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        this.add((Component)new JLabel("Title:"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.INSETS5505, 0, 0));
        this.add((Component)scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, RmaInsets.INSETS5505, 0, 0));
        this.add((Component)this.m_repeateTitle, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.INSETS5555, 0, 0));
    }

    public void setData(TablePrintProperties prop) {
        this.m_properties = prop;
    }

    public void setDefaultTitle(String title) {
        if (title == null) {
            return;
        }
        this.m_titleArea.setText(title);
    }

    @Override
    public void fillPanel() {
        if (this.m_properties == null) {
            return;
        }
        if (!this.m_properties.title.equals("")) {
            this.m_titleArea.setText(this.m_properties.title);
        }
    }

    @Override
    public boolean savePanel() {
        if (this.m_properties == null) {
            return true;
        }
        this.m_properties.title = this.m_titleArea.getText();
        this.m_properties.repeatTitle = this.m_repeateTitle.isSelected();
        return true;
    }

    private class LabelDivider
    extends JPanel {
        public LabelDivider(String label) {
            this.setLayout(new GridBagLayout());
            this.add((Component)new JLabel(label), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)new JSeparator(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(15, 5, 5, 5), 0, 0));
        }
    }
}

