/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import java.awt.FontMetrics;
import java.awt.event.MouseEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import rma.util.RMAIO;

public class ToolTipHeader
extends JTableHeader {
    String[] _toolTips;

    public ToolTipHeader(TableColumnModel model) {
        super(model);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        int col = this.columnAtPoint(e.getPoint());
        if (col < 0) {
            return null;
        }
        if (this.getTable() == null) {
            return null;
        }
        int modelCol = this.getTable().convertColumnIndexToModel(col);
        String retStr = null;
        TableColumn tc = this.getColumnModel().getColumn(col);
        if (e.isControlDown() && e.isShiftDown() && tc != null) {
            return String.valueOf(tc.getWidth());
        }
        try {
            retStr = this._toolTips[modelCol];
        }
        catch (NullPointerException ex) {
            if (tc != null) {
                int strWidth;
                FontMetrics fm = this.getFontMetrics(this.getFont());
                Object headerValue = tc.getHeaderValue();
                if (headerValue != null && (strWidth = fm.stringWidth(headerValue.toString())) > tc.getWidth() && (retStr = headerValue.toString()).indexOf(10) > -1) {
                    retStr = RMAIO.toHtmlString(retStr);
                }
            } else {
                retStr = null;
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            retStr = null;
        }
        if (retStr == null || retStr.length() < 1) {
            retStr = super.getToolTipText(e);
        }
        return retStr;
    }

    public void setToolTipStrings(String[] toolTips) {
        this._toolTips = toolTips;
    }
}

