/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table;

import hec.data.Units;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import rma.swing.RmaJTable;
import rma.swing.table.MleHeadRenderer;
import rma.swing.table.UnitsCellRenderer;

public class UnitsHeaderRenderer
extends MleHeadRenderer
implements TableCellRenderer,
UnitsCellRenderer {
    private int _unitSystem = 1;
    private int _scaleFactor = 1;
    private boolean _useDefaultRenderer;

    @Override
    public void setDisplayScaleFactor(int paramId, double scaleFactor) {
    }

    public UnitsHeaderRenderer() {
        this(false);
    }

    public UnitsHeaderRenderer(boolean useDefaultRenderer) {
        this._useDefaultRenderer = useDefaultRenderer;
        this.setOpaque(true);
        this.setForeground(UIManager.getColor("TableHeader.foreground"));
        this.setBackground(UIManager.getColor("TableHeader.background"));
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        this.setFont(UIManager.getFont("TableHeader.font"));
        ListCellRenderer renderer = this.getCellRenderer();
        ((JLabel)((Object)renderer)).setHorizontalAlignment(0);
        this.setCellRenderer(renderer);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        TableCellRenderer renderer;
        String str = value == null ? "" : value.toString();
        str = this.replaceUnitTemplate(table, str, column);
        if (this._useDefaultRenderer && (renderer = table.getTableHeader().getDefaultRenderer()) != null) {
            return renderer.getTableCellRendererComponent(table, str, isSelected, hasFocus, row, column);
        }
        return super.getTableCellRendererComponent(table, str, isSelected, hasFocus, row, column);
    }

    protected String replaceUnitTemplate(JTable table, String val, int col) {
        if (!(table instanceof RmaJTable)) {
            return val;
        }
        RmaJTable uc = (RmaJTable)table;
        int indexL = -1;
        int indexS = -1;
        indexL = val.indexOf("%L");
        if (indexL == -1 && (indexS = val.indexOf("%S")) == -1) {
            return val;
        }
        StringBuffer sb = new StringBuffer(val);
        String unitsLbl = uc.getDisplayUnitsString(this._unitSystem, uc.convertColumnIndexToModel(col));
        if (indexL >= 0) {
            sb.replace(indexL, indexL + 2, "");
            sb.insert(indexL, unitsLbl);
        }
        if (indexS >= 0) {
            sb.replace(indexS, indexS + 2, "");
            sb.insert(indexS, unitsLbl);
        }
        return sb.toString();
    }

    @Override
    public void setDisplayUnitsSystem(int unitSystem) {
        if (!Units.isValidUnitsSystem(unitSystem)) {
            throw new IllegalArgumentException("Invalid Unit System");
        }
        this._unitSystem = unitSystem;
    }
}

