/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.table.editableheader;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import rma.swing.table.AbstractRmaTableModel;

public class EditableHeaderCheckboxRenderer
extends JCheckBox
implements TableCellRenderer,
MouseListener {
    protected EditableHeaderCheckboxRenderer rendererComponent = this;
    protected int column;
    protected boolean mousePressed = false;
    private String _columnHeaderLabel = "Select All";
    private JTable _table;

    public EditableHeaderCheckboxRenderer(JTable table) {
        this.setHorizontalAlignment(0);
        this._table = table;
        this.rendererComponent.addItemListener(new CheckboxItemListener());
    }

    public EditableHeaderCheckboxRenderer(String columnHeaderLabel, JTable table) {
        this._columnHeaderLabel = columnHeaderLabel;
        this.setHorizontalAlignment(0);
        this._table = table;
        this.rendererComponent.addItemListener(new CheckboxItemListener());
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JTableHeader header;
        if (table != null && (header = table.getTableHeader()) != null) {
            this.rendererComponent.setForeground(header.getForeground());
            this.rendererComponent.setBackground(header.getBackground());
            this.rendererComponent.setFont(header.getFont());
            header.addMouseListener(this.rendererComponent);
        }
        this.setColumn(column);
        this.rendererComponent.setText(this._columnHeaderLabel);
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        return this.rendererComponent;
    }

    protected void setColumn(int column) {
        this.column = column;
    }

    public int getColumn() {
        return this.column;
    }

    protected void handleClickEvent(MouseEvent e) {
        if (this.mousePressed) {
            this.mousePressed = false;
            JTableHeader header = (JTableHeader)e.getSource();
            JTable tableView = header.getTable();
            TableColumnModel columnModel = tableView.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(e.getX());
            int column = tableView.convertColumnIndexToModel(viewColumn);
            if (viewColumn == this.column && e.getClickCount() == 1 && column != -1) {
                this.doClick();
                if (this._table.getModel() instanceof AbstractRmaTableModel) {
                    ((AbstractRmaTableModel)this._table.getModel()).fireTableDataChanged();
                }
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.handleClickEvent(e);
        ((JTableHeader)e.getSource()).repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mousePressed = true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    class CheckboxItemListener
    implements ItemListener {
        CheckboxItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object source = e.getSource();
            if (!(source instanceof AbstractButton)) {
                return;
            }
            boolean checked = e.getStateChange() == 1;
            int y = EditableHeaderCheckboxRenderer.this._table.getRowCount();
            for (int x = 0; x < y; ++x) {
                if (EditableHeaderCheckboxRenderer.this._table.isCellEditable(x, EditableHeaderCheckboxRenderer.this.column)) {
                    EditableHeaderCheckboxRenderer.this._table.setValueAt(new Boolean(checked), x, EditableHeaderCheckboxRenderer.this.column);
                    continue;
                }
                EditableHeaderCheckboxRenderer.this._table.setValueAt(new Boolean(false), x, EditableHeaderCheckboxRenderer.this.column);
            }
        }
    }
}

