/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.text;

import java.awt.Toolkit;
import java.util.Calendar;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.StringContent;
import rma.swing.text.DateDocumentConstants;
import rma.swing.text.RmaDocument;
import rma.util.RMAIO;

public class DateDocument
extends RmaDocument {
    public static final String DDMMMYYYY = "DDMMMYYYY";
    public static final String DDMMM = "DDMMM";
    public static final String MMM = "MMM";
    public static final String YYYY = "YYYY";
    public static final String MMMYYYY = "MMMYYYY";
    int _format = -1;

    public DateDocument(String format) {
        this(format, new StringContent());
    }

    public DateDocument(String format, AbstractDocument.Content c2) {
        super(c2);
        this._content = c2;
        this._toolkit = Toolkit.getDefaultToolkit();
        this.setFormat(format);
    }

    public void setFormat(String format) {
        this.ckFormat(format);
        this.setLength(this._format);
    }

    public int getFormat() {
        return this._format;
    }

    @Override
    protected boolean isValidChar(char c2, int offs) {
        if (!Character.isLetterOrDigit(c2)) {
            return false;
        }
        switch (this._format) {
            case 3: {
                return this.isValid3Format(c2, offs, 0);
            }
            case 4: {
                return this.isValid4Format(c2, offs);
            }
            case 5: {
                return this.isValid5Format(c2, offs);
            }
            case 7: {
                return this.isValid7Format(c2, offs);
            }
            case 9: {
                return this.isValid9Format(c2, offs);
            }
        }
        return false;
    }

    public String incrementDate(int amount) {
        String text;
        Calendar cal = Calendar.getInstance();
        try {
            text = this.getText(0, this.getLength());
        }
        catch (BadLocationException e) {
            System.out.println("incrementDate:" + e);
            return null;
        }
        switch (this._format) {
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 9: {
                try {
                    String d = text.substring(0, 2);
                    String mon = text.substring(2, 5);
                    int month = this.findMonthIndex(mon);
                    int day = RMAIO.parseInt(d);
                    cal.set(5, day);
                    cal.set(2, month);
                    String y = text.substring(5);
                    if (y.isEmpty()) {
                        return null;
                    }
                    int year = RMAIO.parseInt(y);
                    cal.set(1, year);
                    cal.add(5, amount);
                    day = cal.get(5);
                    month = cal.get(2);
                    year = cal.get(1);
                    mon = this.findMonthName(month);
                    d = String.valueOf(day);
                    if (d.length() < 2) {
                        d = "0".concat(d);
                    }
                    y = String.valueOf(year);
                    String date = d.concat(mon).concat(y);
                    return date;
                }
                catch (Exception ex) {
                    return null;
                }
            }
        }
        return null;
    }

    private int findMonthIndex(String month) {
        for (int i = 0; i < DateDocumentConstants.MONTHS.length; ++i) {
            if (!DateDocumentConstants.MONTHS[i].equalsIgnoreCase(month)) continue;
            return i;
        }
        return -1;
    }

    private String findMonthName(int month) {
        if (month < 0 || month >= DateDocumentConstants.MONTHS.length) {
            return "";
        }
        return DateDocumentConstants.MONTHS[month];
    }

    @Override
    public String checkValidChars(String str, int offs, boolean beep) {
        int len = str.length();
        if (len > 1) {
            switch (this._format) {
                case 3: {
                    if (len != 2 && len != 3) break;
                    String upperStr = str.toUpperCase();
                    for (int i = 0; i < DateDocumentConstants.MONTHS.length; ++i) {
                        if (!DateDocumentConstants.MONTHS[i].startsWith(upperStr)) continue;
                        return str;
                    }
                    return "";
                }
                case 7: {
                    int i;
                    boolean ok = false;
                    if (len >= 3) {
                        String upperStr = str.substring(0, 3).toUpperCase();
                        for (i = 0; i < DateDocumentConstants.MONTHS.length; ++i) {
                            if (!DateDocumentConstants.MONTHS[i].startsWith(upperStr)) continue;
                            ok = true;
                        }
                    }
                    if (len > 3) {
                        String s = str.substring(3);
                        for (i = 0; i < s.length(); ++i) {
                            if (Character.isDigit(s.charAt(i))) continue;
                            ok = false;
                        }
                    }
                    if (ok) {
                        return str;
                    }
                    return "";
                }
            }
        }
        return super.checkValidChars(str, offs, beep);
    }

    private boolean isValid3Format(char c2, int pos, int offset) {
        if (!Character.isLetter(c2)) {
            return false;
        }
        switch (pos - offset) {
            case 0: {
                char cc = Character.toUpperCase(c2);
                for (int i = 0; i < DateDocumentConstants.FIRST_LETTER.length; ++i) {
                    if (cc != DateDocumentConstants.FIRST_LETTER[i]) continue;
                    return true;
                }
                return false;
            }
            case 1: {
                Object s;
                try {
                    s = this._content.getString(offset, 1) + c2;
                }
                catch (BadLocationException e) {
                    return true;
                }
                s = ((String)s).toUpperCase();
                for (int i = 0; i < DateDocumentConstants.MONTHS.length; ++i) {
                    if (!DateDocumentConstants.MONTHS[i].startsWith((String)s)) continue;
                    return true;
                }
                return false;
            }
            case 2: {
                Object s;
                try {
                    s = this._content.getString(offset, 2) + c2;
                }
                catch (BadLocationException ee) {
                    return true;
                }
                s = ((String)s).toUpperCase();
                for (int i = 0; i < DateDocumentConstants.MONTHS.length; ++i) {
                    if (!((String)s).equals(DateDocumentConstants.MONTHS[i])) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private boolean isValid4Format(char c2, int pos) {
        switch (pos) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return Character.isDigit(c2);
            }
        }
        return false;
    }

    private boolean isValid5Format(char c2, int pos) {
        switch (pos) {
            case 0: {
                if (!Character.isDigit(c2)) {
                    return false;
                }
                return c2 == '0' || c2 == '1' || c2 == '2' || c2 == '3';
            }
            case 1: {
                String s;
                if (!Character.isDigit(c2)) {
                    char cc = Character.toUpperCase(c2);
                    for (int i = 0; i < DateDocumentConstants.FIRST_LETTER.length; ++i) {
                        if (cc != DateDocumentConstants.FIRST_LETTER[i]) continue;
                        InsertZero iz = new InsertZero();
                        SwingUtilities.invokeLater(iz);
                        return true;
                    }
                    return false;
                }
                try {
                    s = this._content.getString(0, 1);
                }
                catch (BadLocationException ee) {
                    return true;
                }
                char cc = s.charAt(0);
                return cc != '3' || c2 <= '1';
            }
            case 2: 
            case 3: 
            case 4: {
                return this.isValid3Format(c2, pos, 2);
            }
        }
        return false;
    }

    private boolean isValid7Format(char c2, int pos) {
        switch (pos) {
            case 0: 
            case 1: 
            case 2: {
                return this.isValid3Format(c2, pos, 0);
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return Character.isDigit(c2);
            }
        }
        return false;
    }

    protected boolean isValid9Format(char c2, int pos) {
        switch (pos) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return this.isValid5Format(c2, pos);
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return Character.isDigit(c2);
            }
        }
        return false;
    }

    private void ckFormat(String format) {
        if (format != null && format.length() > 1) {
            String f = format.toUpperCase();
            if (f.equals(DDMMMYYYY)) {
                this._format = 9;
            } else if (f.equals(DDMMM)) {
                this._format = 5;
            } else if (f.equals(MMM)) {
                this._format = 3;
            } else if (f.equals(YYYY)) {
                this._format = 4;
            } else if (f.equals(MMMYYYY)) {
                this._format = 7;
            }
            if (this._format > -1) {
                return;
            }
        }
        throw new IllegalArgumentException("Invalid date format " + format);
    }

    public void validate() {
    }

    class InsertZero
    implements Runnable {
        InsertZero() {
        }

        @Override
        public void run() {
            try {
                DateDocument.this.insertString(0, "0", null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

