/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.text;

import java.text.SimpleDateFormat;
import javax.swing.text.BadLocationException;
import rma.swing.text.DateDocument;
import rma.swing.text.DateDocumentConstants;

public class DateTimeDocument
extends DateDocument {
    public static final String FORMAT_STR = "ddMMMyyyy HHmm";
    private SimpleDateFormat _formatter;
    private StringBuilder _buffer;

    public DateTimeDocument() {
        super("DDMMMYYYY");
        this._format = 9;
        this.setLength(14);
        this._formatter = new SimpleDateFormat();
        this._buffer = new StringBuilder(14);
        this._buffer.setLength(14);
    }

    @Override
    public String checkValidChars(String str, int offs, boolean beep) {
        int len = str.length();
        if (offs > 14) {
            return "";
        }
        if (len > 1) {
            boolean ok = false;
            if (len >= 3) {
                int end = Math.min(str.length(), 5);
                String upperStr = str.substring(2, end).toUpperCase();
                for (int i = 0; i < DateDocumentConstants.MONTHS.length; ++i) {
                    if (!DateDocumentConstants.MONTHS[i].startsWith(upperStr)) continue;
                    ok = true;
                    break;
                }
            }
            if (len > 5) {
                String s = str.substring(5);
                if (s.length() > 4) {
                    s = s.substring(0, 4);
                }
                for (int i = 0; i < s.length(); ++i) {
                    if (Character.isDigit(s.charAt(i))) continue;
                    ok = false;
                    break;
                }
            }
            if (ok) {
                return str;
            }
            return "";
        }
        return super.checkValidChars(str, offs, beep);
    }

    @Override
    protected boolean isValidChar(char c2, int offs) {
        if (!Character.isLetterOrDigit(c2) && c2 != ' ' && offs != 9) {
            return false;
        }
        switch (offs) {
            case 9: {
                return c2 == ' ';
            }
            case 10: {
                if (!Character.isDigit(c2)) {
                    return false;
                }
                return c2 == '0' || c2 == '1' || c2 == '2';
            }
            case 11: {
                return Character.isDigit(c2);
            }
            case 12: {
                if (!Character.isDigit(c2)) {
                    return false;
                }
                return c2 == '0' || c2 == '1' || c2 == '2' || c2 == '3' || c2 == '4' || c2 == '5' || c2 == '\u0006';
            }
            case 13: {
                return Character.isDigit(c2);
            }
        }
        return super.isValid9Format(c2, offs);
    }

    @Override
    public void validate() {
        int idx;
        String str;
        int len = this.getLength();
        try {
            str = this.getText(0, len);
        }
        catch (BadLocationException e) {
            return;
        }
        if (len == 13 && (idx = str.indexOf(32)) > -1 && len - idx == 4) {
            try {
                this.insertString(10, "0", null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

