/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.text;

import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.StringContent;
import rma.swing.text.RmaDocument;
import rma.util.RMAIO;

public class DecimalNumberDocument
extends RmaDocument {
    StringBuffer _workBuff = new StringBuffer();
    double _max = Double.MAX_VALUE;
    double _min = -this._max;
    int _lengthOfMax = 0;
    int _lengthOfMin = 0;

    public DecimalNumberDocument() {
        this(new StringContent());
    }

    public DecimalNumberDocument(AbstractDocument.Content c2) {
        super(c2);
    }

    public void setMin(double min) {
        this._min = min;
        this._lengthOfMin = Double.toString(min).length();
    }

    public double getMin() {
        return this._min;
    }

    public void setMax(double max) {
        this._max = max;
        this._lengthOfMax = Double.toString(max).length();
    }

    public double getMax() {
        return this._max;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        double d = 0.0;
        if (str.length() < 1) {
            return;
        }
        this._workBuff.setLength(0);
        this._workBuff.append(this._content.getString(0, this._content.length()));
        this._workBuff.insert(offs, str);
        if (this._workBuff.length() > 0 && this._workBuff.charAt(this._workBuff.length() - 1) == '\n') {
            this._workBuff.setLength(this._workBuff.length() - 1);
        }
        String newstr = this._workBuff.toString();
        newstr = RMAIO.removeChar(newstr, ',');
        try {
            d = Double.valueOf(newstr);
        }
        catch (NumberFormatException nfe) {
            boolean isOk = false;
            if (newstr.length() == 1 && (newstr.equals(".") || newstr.equals("-") || newstr.equals("+"))) {
                isOk = true;
            }
            if (newstr.length() == 2 && (newstr.equals("-.") || newstr.equals("+."))) {
                isOk = true;
            }
            if (newstr.endsWith("E") || newstr.endsWith("e") || newstr.endsWith("e-") || newstr.endsWith("E-")) {
                isOk = true;
            }
            if (isOk) {
                super.insertString(offs, str, a);
            }
            return;
        }
        String dStr = Double.toString(d);
        if (dStr.endsWith(".0")) {
            int index = dStr.indexOf(".0");
            dStr = dStr.substring(0, index);
        }
        if ((dStr.length() >= this._lengthOfMin || ".".equals(str)) && (d > this._max || d < this._min)) {
            System.out.println(d + " > " + this._max + " or < " + this._min);
            return;
        }
        super.insertString(offs, str, a);
    }
}

