/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.text;

import java.awt.Toolkit;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.StringContent;
import rma.swing.text.PathnameDocument;

public class FilenameDocument
extends PathnameDocument {
    public static final int[] INVALID_CHARS = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 44, 47, 58, 59, 60, 61, 62, 63, 64, 91, 92, 93, 94, 96, 123, 124, 125};
    public static final int[] ALLOWABLE_CHARS = new int[]{45, 95, 46, 43, 126};

    public FilenameDocument() {
        this(new StringContent());
    }

    public FilenameDocument(AbstractDocument.Content c2) {
        super(c2);
        this._content = c2;
        this._toolkit = Toolkit.getDefaultToolkit();
    }

    public FilenameDocument(int len) {
        this();
        this._length = len;
    }

    @Override
    protected boolean isValidChar(char c2, int offs) {
        if (!super.isValidChar(c2, offs)) {
            return false;
        }
        if (c2 == ':' || c2 == '/' || c2 == '(' || c2 == ')' || c2 == '+') {
            return false;
        }
        if (c2 == '.') {
            try {
                String currentText = this.getDefaultRootElement().getElement(0).getDocument().getText(0, Integer.parseInt(this.getEndPosition().toString())).toString();
                if (currentText.length() > 1 && c2 == currentText.charAt(currentText.length() - 2)) {
                    return false;
                }
            }
            catch (NumberFormatException | BadLocationException e) {
                e.printStackTrace();
                return true;
            }
        }
        return true;
    }
}

