/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.text;

import java.awt.Toolkit;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.swing.text.StringContent;

public class FixedLengthDocument
extends PlainDocument {
    private int _length = 0;
    AbstractDocument.Content _content;
    private Toolkit _toolkit;
    private boolean _isUppercaseOnly = false;
    private boolean _isLowercaseOnly = false;

    public FixedLengthDocument() {
        this(new StringContent());
    }

    public FixedLengthDocument(AbstractDocument.Content c2) {
        super(c2);
        this._content = c2;
        this._toolkit = Toolkit.getDefaultToolkit();
    }

    public FixedLengthDocument(int len) {
        this();
        this._length = len;
    }

    public void setLength(int length) {
        this._length = length;
    }

    public int getLength(int length) {
        return this._length;
    }

    public void setUppercase() {
        this._isLowercaseOnly = false;
        this._isUppercaseOnly = true;
    }

    public boolean getUppercase() {
        return this._isUppercaseOnly;
    }

    public void setLowercase() {
        this._isLowercaseOnly = true;
        this._isUppercaseOnly = false;
    }

    public boolean getLowerCase() {
        return this._isLowercaseOnly;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (str == null) {
            super.insertString(offs, str, a);
            return;
        }
        if (this._isUppercaseOnly) {
            str = str.toUpperCase();
        } else if (this._isLowercaseOnly) {
            str = str.toLowerCase();
        }
        int len = this._content.length();
        if (str.length() + len > this._length + 1) {
            int num = this._length + 1 - len;
            if (num <= 0) {
                this._toolkit.beep();
            }
            super.insertString(offs, new String(str.substring(0, num)), a);
        } else {
            super.insertString(offs, str, a);
        }
    }
}

