/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.text;

import java.awt.Toolkit;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.swing.text.StringContent;

public class LongDocument
extends PlainDocument {
    protected int _length = 0;
    AbstractDocument.Content _content;
    private Toolkit _toolkit;
    StringBuffer _workBuff = new StringBuffer();
    long _min = Long.MIN_VALUE;
    long _max = Long.MAX_VALUE;
    private boolean _allowsNegativeNumbers = true;

    public LongDocument() {
        this(new StringContent());
    }

    public LongDocument(AbstractDocument.Content c2) {
        super(c2);
        this._content = c2;
        this._toolkit = Toolkit.getDefaultToolkit();
    }

    public void setMin(long min) {
        this._min = min;
    }

    public long getMin() {
        return this._min;
    }

    public void setMax(long max) {
        this._max = max;
    }

    public long getMax() {
        return this._max;
    }

    public void setLength(int length) {
        this._length = length;
    }

    public int getLength(int length) {
        return this._length;
    }

    public void setAllowsNegativeNumbers(boolean b) {
        this._allowsNegativeNumbers = b;
    }

    public boolean allowsNegativeNumber() {
        return this._allowsNegativeNumbers;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        long i;
        block12: {
            i = 0L;
            String currentStr = str;
            if (str == null || str.equals("")) {
                str = "0";
            }
            if (str.length() < 1) {
                return;
            }
            if (!this._allowsNegativeNumbers && "-".equals(str)) {
                return;
            }
            this._workBuff.setLength(0);
            this._workBuff.append(this._content.getString(0, this._content.length()));
            this._workBuff.insert(offs, str);
            if (this._workBuff.length() > 0 && this._workBuff.charAt(this._workBuff.length() - 1) == '\n') {
                this._workBuff.setLength(this._workBuff.length() - 1);
            }
            String newstr = this._workBuff.substring(0);
            if (this._content.length() > 0) {
                try {
                    i = Long.parseLong(newstr);
                }
                catch (NumberFormatException nf) {
                    boolean isOk = false;
                    if (newstr.length() == 1 && newstr.equals("-")) {
                        isOk = true;
                    }
                    if (isOk) break block12;
                    return;
                }
            }
        }
        if (i > this._max || i < this._min) {
            return;
        }
        int len = this._content.length();
        if (this._length > 0 && str.length() + len > this._length + 1) {
            int num = this._length + 1 - len;
            if (num <= 0) {
                this._toolkit.beep();
            }
            super.insertString(offs, new String(str.substring(0, num)), a);
        } else {
            super.insertString(offs, str, a);
        }
    }
}

