/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.text;

import java.awt.Toolkit;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.StringContent;
import rma.swing.text.RmaDocument;

public class MilitaryTimeDocument
extends RmaDocument {
    private boolean _allowsMinutes = true;
    private boolean _allows2400 = true;

    public MilitaryTimeDocument() {
        this(new StringContent());
    }

    public MilitaryTimeDocument(AbstractDocument.Content c2) {
        super(c2);
        this._content = c2;
        this._toolkit = Toolkit.getDefaultToolkit();
        this.setLength(4);
    }

    public void setAllowsHour2400(boolean b) {
        this._allows2400 = b;
    }

    public boolean getAllowsHour2400() {
        return this._allows2400;
    }

    public void setAllowsMinutes(boolean b) {
        this._allowsMinutes = b;
    }

    public boolean getAllowsMinutes() {
        return this._allowsMinutes;
    }

    @Override
    protected boolean isValidChar(char c2, int offs) {
        if (!Character.isDigit(c2)) {
            return false;
        }
        switch (offs) {
            case 0: {
                if (c2 <= '2') break;
                return false;
            }
            case 1: {
                String s = "";
                try {
                    s = this._content.getString(0, 1);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                if (s.equals("2") && c2 > '4') {
                    return false;
                }
                if (this._allows2400 || !s.equals("2") || c2 < '4') break;
                return false;
            }
            case 2: {
                if (!this._allowsMinutes && c2 != '0') {
                    return false;
                }
                if (c2 > '5') {
                    return false;
                }
                return this.validHour24(c2);
            }
            case 3: {
                if (!this._allowsMinutes && c2 != '0') {
                    return false;
                }
                if (c2 > '9') {
                    return false;
                }
                return this.validHour24(c2);
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private boolean validHour24(char c2) {
        String s;
        try {
            s = this._content.getString(0, 2);
        }
        catch (BadLocationException e) {
            return true;
        }
        return !s.equals("24") || c2 == '0';
    }
}

