/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.text;

import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.StringContent;
import rma.swing.text.RmaDocument;

public class PathnameDocument
extends RmaDocument {
    public static final int[] INVALID_CHARS = new int[]{33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 44, 59, 60, 61, 62, 63, 64, 91, 92, 93, 94, 96, 123, 124, 125};
    public static final int[] ALLOWABLE_CHARS = new int[]{32, 40, 41, 45, 95, 46, 43, 126, 47, 58};
    private List _additionalChars;
    private transient AllowableCharacter _allowChar;
    private boolean _allowWindowsPaths = false;

    public PathnameDocument() {
        this(new StringContent());
    }

    public PathnameDocument(AbstractDocument.Content c2) {
        super(c2);
        this._content = c2;
        this._toolkit = Toolkit.getDefaultToolkit();
    }

    public PathnameDocument(int len) {
        this();
        this._length = len;
    }

    public void setAllowWindowsPath(boolean allowWindowsPaths) {
        this._allowWindowsPaths = allowWindowsPaths;
        PathnameDocument.INVALID_CHARS[3] = this._allowWindowsPaths ? 0 : 36;
    }

    @Override
    protected boolean isValidChar(char c2, int offs) {
        if (!Character.isLetterOrDigit(c2)) {
            int len = ALLOWABLE_CHARS.length;
            for (int i = 0; i < len; ++i) {
                if (c2 == ALLOWABLE_CHARS[i]) {
                    return c2 != ':' || offs == 1;
                }
                if (this._additionalChars == null) continue;
                this._allowChar.ch = c2;
                this._allowChar.chPos = offs;
                if (!this._additionalChars.contains(this._allowChar)) continue;
                return true;
            }
            if (c2 == '$' && this._allowWindowsPaths) {
                String text = null;
                int length = this.getLength();
                try {
                    text = this.getText(0, length);
                }
                catch (BadLocationException e) {
                    System.out.println("BadLocationException " + e);
                    e.printStackTrace();
                    return false;
                }
                if (offs > 0 && length == 0) {
                    text = this.getCurrentInsertString();
                }
                if (!text.startsWith("\\")) {
                    return false;
                }
                return (text = text.substring(offs - 2, offs)).charAt(0) == '\\' && Character.isLetter(text.charAt(1));
            }
            return false;
        }
        return true;
    }

    public void addAllowableChar(char ch, int pos) {
        AllowableCharacter ac;
        if (this._additionalChars == null) {
            this._additionalChars = new ArrayList();
            this._allowChar = new AllowableCharacter();
        }
        if (this._additionalChars.contains(ac = new AllowableCharacter(ch, pos))) {
            return;
        }
        this._additionalChars.add(ac);
    }

    class AllowableCharacter {
        int chPos;
        char ch;

        AllowableCharacter() {
        }

        AllowableCharacter(char c2, int pos) {
            this.ch = c2;
            this.chPos = pos;
        }

        public boolean equals(Object obj) {
            if (obj instanceof AllowableCharacter) {
                return this.equals((AllowableCharacter)obj);
            }
            return false;
        }

        public boolean equals(AllowableCharacter ac) {
            if (ac == null) {
                return false;
            }
            if (ac == this) {
                return true;
            }
            return ac.ch == this.ch && (ac.chPos == -1 || ac.chPos == this.chPos);
        }

        public String toString() {
            return "char=[" + this.ch + "] pos=" + this.chPos;
        }
    }
}

