/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.text;

import java.awt.Toolkit;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import rma.swing.RmaJDateField;
import rma.swing.text.DateDocument;

public class RmaDateVerifier
extends InputVerifier {
    protected static RmaDateVerifier verifier = null;
    private Toolkit toolkit = Toolkit.getDefaultToolkit();

    private RmaDateVerifier() {
    }

    public static RmaDateVerifier getVerifier() {
        if (verifier == null) {
            verifier = new RmaDateVerifier();
        }
        return verifier;
    }

    @Override
    public boolean verify(JComponent input) {
        return this.verify(input, true);
    }

    public boolean verify(JComponent input, boolean showError) {
        if (input == null) {
            return false;
        }
        if (!(input instanceof RmaJDateField)) {
            return false;
        }
        RmaJDateField df = (RmaJDateField)input;
        if (!df.isEditable() || !df.isEnabled()) {
            return true;
        }
        DateDocument dd = df.getDateDocument();
        int len = df.getText().length();
        boolean error = false;
        String errorString = null;
        String format = df.getFormat();
        dd.validate();
        len = df.getText().length();
        int ddlen = format.length();
        if (len == 0 && !df.isEmptyOk() || len > 0 && len < ddlen) {
            errorString = "Date Field must be of the format " + format;
            error = true;
        } else {
            String text = df.getText();
            String s = dd.checkValidChars(text, 0, false);
            if (!s.equals(text)) {
                errorString = "Invalid date. Must have the format " + format;
                error = true;
            }
        }
        if (error) {
            if (showError) {
                df.errorMsg(errorString);
            }
            return false;
        }
        return true;
    }
}

