/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.text;

import java.awt.Toolkit;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import rma.swing.RmaJDecimalField;

public class RmaDecimalVerifier
extends InputVerifier {
    protected static RmaDecimalVerifier verifier = null;
    private Toolkit toolkit = Toolkit.getDefaultToolkit();

    private RmaDecimalVerifier() {
    }

    public static RmaDecimalVerifier getVerifier() {
        if (verifier == null) {
            verifier = new RmaDecimalVerifier();
        }
        return verifier;
    }

    @Override
    public boolean verify(JComponent input) {
        if (input == null) {
            return false;
        }
        if (!(input instanceof RmaJDecimalField)) {
            return false;
        }
        RmaJDecimalField df = (RmaJDecimalField)input;
        boolean showErrorMsg = true;
        StringBuilder errString = new StringBuilder();
        if (df.getText().length() < 1) {
            if (df.isEmptyOk()) {
                return true;
            }
            errString.append("Field cannot be empty");
        }
        df.getTableMinMax();
        double minValue = df.getMinValue();
        double maxValue = df.getMaxValue();
        if (minValue != Double.NEGATIVE_INFINITY && df.getValue() < minValue) {
            if (df.isEmptyOk()) {
                errString.append("Value may be empty or must not be less than ").append(minValue);
            } else {
                if (errString.length() > 0) {
                    errString.append("\n");
                }
                errString.append("Value must not be less than ").append(minValue);
            }
        }
        if (maxValue != Double.NEGATIVE_INFINITY && df.getValue() > maxValue) {
            if (df.isEmptyOk()) {
                errString.append("Value may be empty or must not exceed ").append(maxValue);
            } else {
                if (errString.length() > 0) {
                    errString.append("\n");
                }
                errString.append("Value must not exceed ").append(maxValue);
            }
        }
        if (errString.length() > 0) {
            if (showErrorMsg) {
                df.setInputVerifier(null);
                df.errorMsg(errString.toString());
                df.setInputVerifier(this);
            }
            return false;
        }
        return true;
    }
}

