/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.text;

import java.awt.Toolkit;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.swing.text.StringContent;

public class RmaDocument
extends PlainDocument {
    protected int _length = 0;
    protected AbstractDocument.Content _content;
    protected Toolkit _toolkit;
    protected boolean _isUppercaseOnly = false;
    protected boolean _isLowercaseOnly = false;
    protected StringBuffer tempBuf = new StringBuffer();
    private String _currentInsertString = "";

    public RmaDocument() {
        this(new StringContent());
    }

    public RmaDocument(AbstractDocument.Content c2) {
        super(c2);
        this._content = c2;
        this._toolkit = Toolkit.getDefaultToolkit();
    }

    public RmaDocument(int len) {
        this();
        this._length = len;
    }

    public void setLength(int length) {
        this._length = length;
    }

    public int getLength(int length) {
        return this._length;
    }

    public void setUppercase() {
        this._isLowercaseOnly = false;
        this._isUppercaseOnly = true;
    }

    public boolean getUppercase() {
        return this._isUppercaseOnly;
    }

    public void setLowercase() {
        this._isLowercaseOnly = true;
        this._isUppercaseOnly = false;
    }

    public boolean getLowercase() {
        return this._isLowercaseOnly;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (str == null) {
            return;
        }
        if (this._isUppercaseOnly) {
            str = str.toUpperCase();
        } else if (this._isLowercaseOnly) {
            str = str.toLowerCase();
        }
        if (str.length() > 0) {
            str = this.checkValidChars(str, offs, true);
        }
        int len = this._content.length();
        if (this._length > 0 && str.length() + len > this._length + 1) {
            int num = this._length + 1 - len;
            if (num <= 0) {
                this._toolkit.beep();
                return;
            }
            super.insertString(offs, new String(str.substring(0, num)), a);
        } else {
            super.insertString(offs, str, a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checkValidChars(String str, int offs, boolean beep) {
        int len = str.length();
        this._currentInsertString = str;
        this.tempBuf.setLength(0);
        boolean beeped = false;
        try {
            for (int i = 0; i < len; ++i) {
                char c2 = str.charAt(i);
                if (this.isValidChar(c2, offs + i)) {
                    this.tempBuf.append(c2);
                    continue;
                }
                if (beeped || !beep) continue;
                this._toolkit.beep();
                beeped = true;
            }
            if (this.tempBuf.length() > 0) {
                String string = this.tempBuf.toString();
                return string;
            }
            String string = "";
            return string;
        }
        finally {
            this._currentInsertString = "";
        }
    }

    protected String getCurrentInsertString() {
        return this._currentInsertString;
    }

    protected boolean isValidChar(char c2, int offs) {
        return true;
    }
}

