/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.text;

import java.awt.Toolkit;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import rma.swing.RmaJIntegerField;

public class RmaIntegerVerifier
extends InputVerifier {
    protected static RmaIntegerVerifier verifier = null;
    private Toolkit toolkit = Toolkit.getDefaultToolkit();

    private RmaIntegerVerifier() {
    }

    public static RmaIntegerVerifier getVerifier() {
        if (verifier == null) {
            verifier = new RmaIntegerVerifier();
        }
        return verifier;
    }

    @Override
    public boolean verify(JComponent input) {
        return this.verify(input, true);
    }

    public boolean verify(JComponent input, boolean showErrorMsg) {
        if (input == null) {
            return false;
        }
        if (!(input instanceof RmaJIntegerField)) {
            return false;
        }
        RmaJIntegerField df = (RmaJIntegerField)input;
        StringBuffer errString = new StringBuffer();
        if (df.getText().length() < 1) {
            if (df.isEmptyOk()) {
                return true;
            }
            errString.append("Field cannot be empty");
        }
        int minValue = df.getMinValue();
        int maxValue = df.getMaxValue();
        if (minValue != Integer.MIN_VALUE && df.getValue() < minValue) {
            errString.append("Value must be at least " + minValue);
        }
        if (maxValue != Integer.MIN_VALUE && df.getValue() > maxValue) {
            errString.append("Value must be less than or equal to " + maxValue);
        }
        if (errString.length() > 0) {
            if (df.getName() != null) {
                errString.insert(0, df.getName() + " ");
            }
            if (df.isEmptyOk()) {
                errString.append(" or empty");
            }
            if (showErrorMsg) {
                df.setInputVerifier(null);
                df.errorMsg(errString.toString());
                df.setInputVerifier(this);
            }
            return false;
        }
        return true;
    }
}

