/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.text;

import java.awt.Toolkit;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import rma.swing.RmaJLongField;

public class RmaLongVerifier
extends InputVerifier {
    protected static RmaLongVerifier verifier = null;
    private Toolkit toolkit = Toolkit.getDefaultToolkit();

    private RmaLongVerifier() {
    }

    public static RmaLongVerifier getVerifier() {
        if (verifier == null) {
            verifier = new RmaLongVerifier();
        }
        return verifier;
    }

    @Override
    public boolean verify(JComponent input) {
        return this.verify(input, true);
    }

    public boolean verify(JComponent input, boolean showErrorMsg) {
        if (input == null) {
            return false;
        }
        if (!(input instanceof RmaJLongField)) {
            return false;
        }
        RmaJLongField df = (RmaJLongField)input;
        if (df.getText().length() < 1 && df.isEmptyOk()) {
            return true;
        }
        StringBuffer errString = new StringBuffer();
        long minValue = df.getMinValue();
        long maxValue = df.getMaxValue();
        if (minValue != Long.MIN_VALUE && df.getValue() < minValue) {
            errString.append("Value must be at least " + minValue);
        }
        if (maxValue != Long.MIN_VALUE && df.getValue() > maxValue) {
            errString.append("Value must be less than " + maxValue);
        }
        if (errString.length() > 0) {
            if (df.getName() != null) {
                errString.insert(0, df.getName() + " ");
            }
            if (df.isEmptyOk()) {
                errString.append(" or empty");
            }
            if (showErrorMsg) {
                df.setInputVerifier(null);
                df.errorMsg(errString.toString());
                df.setInputVerifier(this);
            }
            return false;
        }
        return true;
    }
}

