/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.text;

import java.awt.EventQueue;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import rma.swing.RmaJ24HourTimeField;
import rma.swing.text.MilitaryTimeDocument;

public class RmaMilitaryTimeVerifier
extends InputVerifier {
    protected static RmaMilitaryTimeVerifier verifier = null;

    private RmaMilitaryTimeVerifier() {
    }

    public static RmaMilitaryTimeVerifier getVerifier() {
        if (verifier == null) {
            verifier = new RmaMilitaryTimeVerifier();
        }
        return verifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verify(JComponent input) {
        if (input == null) {
            return false;
        }
        if (!(input instanceof RmaJ24HourTimeField)) {
            return false;
        }
        RmaJ24HourTimeField df = (RmaJ24HourTimeField)input;
        df.setInputVerifier(null);
        try {
            int len = df.getText().length();
            boolean error = false;
            boolean showError = true;
            Object errorStr = "";
            MilitaryTimeDocument mtd = df.getMilitaryTimeDocument();
            if (len == 0 && !df.isEmptyOk() || len > 0 && len < 4) {
                errorStr = "Time Field must be 4 digits long";
                error = true;
            } else {
                double val = df.getValue();
                if (val > 2400.0 || val < 0.0) {
                    errorStr = "Time Field must be between 0000 and 2400";
                    error = true;
                } else {
                    String text = df.getText();
                    String s = mtd.checkValidChars(text, 0, false);
                    if (!s.equals(text)) {
                        errorStr = "Invalid time " + text;
                        error = true;
                    }
                    if (error) {
                        errorStr = "Invalid time " + text;
                    }
                }
            }
            if (error) {
                if (showError) {
                    df.errorMsg((String)errorStr);
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            EventQueue.invokeLater(() -> df.setInputVerifier(this));
        }
    }
}

