/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.text;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.EventListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import rma.swing.event.InsertModeChangedListener;

public class ToggleInsertDocument
extends PlainDocument
implements KeyListener {
    private boolean _insertMode = true;

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 155 && e.getModifiers() == 0) {
            this.toggleInsertMode();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public boolean isInsertMode() {
        return this._insertMode;
    }

    public void toggleInsertMode() {
        this._insertMode = !this._insertMode;
        this.fireInsertModeChanged();
    }

    public void setInsertMode(boolean _insertMode) {
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        int docLength;
        if (!this._insertMode && offs < (docLength = this.getLength())) {
            int remainder = docLength - offs;
            int length = str.length();
            length = length > remainder ? remainder : length;
            this.remove(offs, length);
        }
        super.insertString(offs, str, a);
    }

    public void addInsertModeChangedListener(InsertModeChangedListener l) {
        this.listenerList.add(InsertModeChangedListener.class, l);
    }

    protected void fireInsertModeChanged() {
        EventListener[] listeners = this.listenerList.getListeners(InsertModeChangedListener.class);
        for (int i = listeners.length - 1; i >= 0; --i) {
            ((InsertModeChangedListener)listeners[i]).insertModeChanged(this, this._insertMode);
        }
    }
}

