/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.tree;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import rma.swing.RmaJCheckBox;
import rma.swing.tree.CheckBoxNode;

public class CheckBoxRenderer
extends DefaultTreeCellRenderer {
    protected JPanel _panel = new JPanel(new BorderLayout(0, 0));
    protected RmaJCheckBox _checkBox;
    protected JLabel _label;

    public CheckBoxRenderer() {
        this._panel.setBackground(UIManager.getColor("Tree.textBackground"));
        this.setOpaque(false);
        this._label = new JLabel();
        this._panel.add((Component)this._label, "Center");
        this._checkBox = new RmaJCheckBox();
        this._checkBox.setForeground(UIManager.getColor("Tree.textForeground"));
        this._checkBox.setBackground(UIManager.getColor("Tree.selectionBackground"));
        this._label.setForeground(UIManager.getColor("Tree.textForeground"));
        this._label.setBackground(UIManager.getColor("Tree.selectionBackground"));
        this._panel.add((Component)this._checkBox, "West");
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (!(value instanceof CheckBoxNode)) {
            Component comp = super.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, hasFocus);
            return comp;
        }
        this._label.setText("");
        String stringValue = tree.convertValueToText(value, isSelected, expanded, leaf, row, hasFocus);
        this._checkBox.setSelected(((CheckBoxNode)value).isSelected());
        this._label.setText(stringValue);
        this._checkBox.setOpaque(hasFocus);
        this._label.setOpaque(hasFocus);
        this.setForegroundColor(isSelected);
        this.setBackgroundColor(isSelected, hasFocus);
        return this._panel;
    }

    private void setBackgroundColor(boolean isSelected, boolean hasFocus) {
        Color clr = null;
        clr = isSelected ? UIManager.getColor("Tree.selectionBackground") : UIManager.getColor("Tree.textBackground");
        this._checkBox.setBackground(clr);
        this._label.setBackground(clr);
    }

    protected void setForegroundColor(boolean isSelected) {
        Color clr;
        if (isSelected) {
            clr = UIManager.getColor("Tree.selectionForeground");
            this._checkBox.setOpaque(true);
            this._label.setOpaque(true);
        } else {
            clr = UIManager.getColor("Tree.textForeground");
        }
        this._checkBox.setForeground(clr);
        this._label.setForeground(clr);
    }

    public Dimension getCheckBoxOffset() {
        return new Dimension(this.getPreferredSize().width, 0);
    }
}

