/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.tree.TreeCellRenderer;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJPanel;
import rma.swing.tree.CheckBoxNode;
import rma.swing.tree.RmaTreeCellRenderer;

public class CheckBoxTreeRenderer
extends RmaJPanel
implements TreeCellRenderer {
    protected RmaJCheckBox _checkBox;
    protected TreeLabel _label;
    private RmaTreeCellRenderer _defaultRenderer;

    public CheckBoxTreeRenderer() {
        this.setLayout(null);
        this._checkBox = new RmaJCheckBox();
        this.add(this._checkBox);
        this._label = new TreeLabel();
        this.add(this._label);
        this._checkBox.setBackground(UIManager.getColor("Tree.textBackground"));
        this._label.setForeground(UIManager.getColor("Tree.textForeground"));
        this._defaultRenderer = new RmaTreeCellRenderer();
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String stringValue = tree.convertValueToText(value, isSelected, expanded, leaf, row, hasFocus);
        if (!(value instanceof CheckBoxNode)) {
            return this._defaultRenderer.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, hasFocus);
        }
        this.setEnabled(tree.isEnabled());
        if (isSelected) {
            this._label.setForeground(UIManager.getColor("Tree.selectionForeground"));
        } else {
            this._label.setForeground(UIManager.getColor("Tree.textForeground"));
        }
        this._checkBox.setSelected(((CheckBoxNode)value).isSelected());
        this._label.setFont(tree.getFont());
        this._label.setText(stringValue);
        this._label.setSelected(isSelected);
        this._label.setFocus(hasFocus);
        return this;
    }

    public RmaTreeCellRenderer getDefaultRenderer() {
        return this._defaultRenderer;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d_check = this._checkBox.getPreferredSize();
        Dimension d_label = this._label.getPreferredSize();
        return new Dimension(d_check.width + d_label.width, d_check.height < d_label.height ? d_label.height : d_check.height);
    }

    @Override
    public void doLayout() {
        Dimension d_check = this._checkBox.getPreferredSize();
        Dimension d_label = this._label.getPreferredSize();
        int y_check = 0;
        int y_label = 0;
        if (d_check.height < d_label.height) {
            y_check = (d_label.height - d_check.height) / 2;
        } else {
            y_label = (d_check.height - d_label.height) / 2;
        }
        this._checkBox.setLocation(0, y_check);
        this._checkBox.setBounds(0, y_check - 2, d_check.width, d_check.height);
        this._label.setLocation(d_check.width, y_label);
        this._label.setBounds(d_check.width, y_label - 3, d_label.width, d_label.height);
    }

    @Override
    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    public class TreeLabel
    extends JLabel {
        boolean isSelected;
        boolean hasFocus;

        @Override
        public void setBackground(Color color) {
            if (color instanceof ColorUIResource) {
                color = null;
            }
            super.setBackground(color);
        }

        @Override
        public void paint(Graphics g) {
            String str = this.getText();
            if (str != null && 0 < str.length()) {
                if (this.isSelected) {
                    g.setColor(UIManager.getColor("Tree.selectionBackground"));
                } else {
                    g.setColor(UIManager.getColor("Tree.textBackground"));
                }
                Dimension d = this.getPreferredSize();
                int imageOffset = 0;
                Icon currentI = this.getIcon();
                if (currentI != null) {
                    imageOffset = currentI.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
                }
                g.fillRect(imageOffset, 0, d.width - 1 - imageOffset, d.height);
                if (this.hasFocus) {
                    g.setColor(UIManager.getColor("Tree.selectionBorderColor"));
                    g.drawRect(imageOffset, 0, d.width - 1 - imageOffset, d.height - 1);
                }
            }
            super.paint(g);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension retDimension = super.getPreferredSize();
            if (retDimension != null) {
                retDimension = new Dimension(retDimension.width + 3, retDimension.height + 2);
            }
            return retDimension;
        }

        public void setSelected(boolean isSelected) {
            this.isSelected = isSelected;
        }

        public void setFocus(boolean hasFocus) {
            this.hasFocus = hasFocus;
        }
    }
}

