/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.tree;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import rma.swing.event.NodeSelectedListener;
import rma.swing.tree.CheckBoxNode;
import rma.swing.tree.PopupTreeNode;

public class NodeSelectionListener
extends MouseAdapter {
    protected JTree _tree;
    protected int _iconWidth;
    protected Vector _nodeListeners = new Vector(4);

    public NodeSelectionListener() {
        Icon icon = UIManager.getIcon("CheckBox.icon");
        this._iconWidth = icon.getIconWidth();
    }

    public NodeSelectionListener(JTree tree) {
        this();
        this.setTree(tree);
    }

    public void setTree(JTree tree) {
        this._tree = tree;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        int row = this._tree.getRowForLocation(x, y);
        TreePath path = this._tree.getPathForRow(row);
        boolean toggle = false;
        if (!this._tree.isEnabled()) {
            return;
        }
        if (path != null) {
            Rectangle r = this._tree.getRowBounds(row);
            Object obj = path.getLastPathComponent();
            if (this.isOverCheckBox(e.getPoint()) && obj instanceof CheckBoxNode) {
                CheckBoxNode node = (CheckBoxNode)obj;
                boolean isSelected = !node.isSelected();
                node.setSelected(isSelected);
                ((DefaultTreeModel)this._tree.getModel()).nodeChanged((TreeNode)((Object)node));
                if (row == 0) {
                    this._tree.revalidate();
                    this._tree.repaint();
                }
                this.fireNodeSelected(node);
            } else if (e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) {
                this._tree.setSelectionPath(path);
                Container popupMenu = null;
                if (obj instanceof PopupTreeNode) {
                    PopupTreeNode node = (PopupTreeNode)obj;
                    popupMenu = node.getPopupMenu();
                }
                if (popupMenu != null && popupMenu.getComponentCount() > 0) {
                    this.showPopup((JPopupMenu)popupMenu, x, y);
                }
                return;
            }
        }
    }

    private void showPopup(JPopupMenu popupMenu, int x, int y) {
        if (popupMenu == null) {
            return;
        }
        Dimension dim = popupMenu.getPreferredSize();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension scrnsiz = toolkit.getScreenSize();
        Point pt0 = this._tree.getLocationOnScreen();
        int windowsToolBarHeight = 50;
        int offset = scrnsiz.height - (pt0.y + y + dim.height + windowsToolBarHeight);
        if (offset < 0) {
            y += offset;
        }
        popupMenu.show(this._tree, x, y);
    }

    public boolean isOverCheckBox(Point p) {
        if (p == null) {
            return false;
        }
        int row = this._tree.getRowForLocation(p.x, p.y);
        if (row >= 0) {
            Rectangle r = this._tree.getRowBounds(row);
            return p.x >= r.x && p.x <= r.x + this._iconWidth + 5;
        }
        return false;
    }

    protected void fireNodeSelected(CheckBoxNode node) {
        for (int i = this._nodeListeners.size() - 1; i >= 0; --i) {
            ((NodeSelectedListener)this._nodeListeners.get(i)).nodeSelected(node);
        }
    }

    public void addNodeSelectedListener(NodeSelectedListener listener) {
        if (listener == null) {
            return;
        }
        this._nodeListeners.add(listener);
    }

    public void removeNodeSelectedListener(NodeSelectedListener listener) {
        if (listener == null) {
            return;
        }
        this._nodeListeners.remove(listener);
    }
}

