/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.tree;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import rma.swing.tree.PopupTreeNode;

public class PopupNodeListener
extends MouseAdapter {
    JTree _tree;

    public PopupNodeListener(JTree tree) {
        if (tree == null) {
            throw new NullPointerException("Tree can not be null");
        }
        this._tree = tree;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        int row = this._tree.getRowForLocation(x, y);
        TreePath path = this._tree.getPathForRow(row);
        boolean toggle = false;
        if (path != null) {
            Object obj = path.getLastPathComponent();
            if (e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) {
                this._tree.setSelectionPath(path);
                if (obj instanceof PopupTreeNode) {
                    JPopupMenu popup = ((PopupTreeNode)obj).getPopupMenu();
                    if (popup == null) {
                        return;
                    }
                    popup.show(this._tree, e.getX(), e.getY());
                }
                return;
            }
        }
    }
}

